/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.io.LoggerReader;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerBufferedReader
extends BufferedReader {
    private static final String FQCN = LoggerBufferedReader.class.getName();

    protected LoggerBufferedReader(Reader reader, ExtendedLogger logger, String fqcn, Level level, Marker marker) {
        super(new LoggerReader(reader, logger, fqcn == null ? FQCN : fqcn, level, marker));
    }

    protected LoggerBufferedReader(Reader reader, int size, ExtendedLogger logger, String fqcn, Level level, Marker marker) {
        super(new LoggerReader(reader, logger, fqcn == null ? FQCN : fqcn, level, marker), size);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return super.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return super.read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int len = target.remaining();
        char[] cbuf = new char[len];
        int charsRead = this.read(cbuf, 0, len);
        if (charsRead > 0) {
            target.put(cbuf, 0, charsRead);
        }
        return charsRead;
    }

    @Override
    public String readLine() throws IOException {
        return super.readLine();
    }
}

