/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.conf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlConfig
implements ConfigurationAdapter {
    private final Yaml yaml;
    private Map<String, Object> config;
    private final File file;

    public YamlConfig() {
        this(new File("config.yml"));
    }

    public YamlConfig(File file) {
        this.file = file;
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(options);
    }

    @Override
    public void load() {
        this.load(true);
    }

    public void load(boolean doPermissions) {
        Map groups;
        try {
            this.file.createNewFile();
            try (FileInputStream is = new FileInputStream(this.file);){
                try {
                    this.config = (Map)this.yaml.load(is);
                }
                catch (YAMLException ex) {
                    throw new RuntimeException("Invalid configuration encountered - this is a configuration error and NOT a bug! Please attempt to fix the error or see https://www.spigotmc.org/ for help.", ex);
                }
            }
            this.config = this.config == null ? new CaseInsensitiveMap<Object>() : new CaseInsensitiveMap<Object>(this.config);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not load configuration!", ex);
        }
        if (!doPermissions) {
            return;
        }
        Map permissions = this.get("permissions", new HashMap());
        if (permissions.isEmpty()) {
            permissions.put("default", Arrays.asList("bungeecord.command.server", "bungeecord.command.list"));
            permissions.put("admin", Arrays.asList("bungeecord.command.alert", "bungeecord.command.end", "bungeecord.command.ip", "bungeecord.command.reload"));
        }
        if ((groups = (Map)this.get("groups", new HashMap())).isEmpty()) {
            groups.put("md_5", Collections.singletonList("admin"));
        }
    }

    private <T> T get(String path, T def) {
        return this.get(path, def, this.config);
    }

    private <T> T get(String path, T def, Map submap) {
        int index = path.indexOf(46);
        if (index == -1) {
            Object val = submap.get(path);
            if (val == null && def != null) {
                val = def;
                submap.put(path, def);
                this.save();
            }
            return (T)val;
        }
        String first = path.substring(0, index);
        String second = path.substring(index + 1, path.length());
        LinkedHashMap sub = (LinkedHashMap)submap.get(first);
        if (sub == null) {
            sub = new LinkedHashMap();
            submap.put(first, sub);
        }
        return this.get(second, def, sub);
    }

    private void set(String path, Object val, Map submap) {
        int index = path.indexOf(46);
        if (index == -1) {
            if (val == null) {
                submap.remove(path);
            } else {
                submap.put(path, val);
            }
            this.save();
        } else {
            String first = path.substring(0, index);
            String second = path.substring(index + 1, path.length());
            LinkedHashMap sub = (LinkedHashMap)submap.get(first);
            if (sub == null) {
                sub = new LinkedHashMap();
                submap.put(first, sub);
            }
            this.set(second, val, sub);
        }
    }

    private void save() {
        try (FileWriter wr = new FileWriter(this.file);){
            this.yaml.dump(this.config, wr);
        }
        catch (IOException ex) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not save config", ex);
        }
    }

    @Override
    public int getInt(String path, int def) {
        return this.get(path, def);
    }

    @Override
    public String getString(String path, String def) {
        return this.get(path, def);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.get(path, def);
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        Map base = this.get("servers", Collections.singletonMap("lobby", new HashMap()));
        HashMap<String, ServerInfo> ret = new HashMap<String, ServerInfo>();
        for (Map.Entry entry : base.entrySet()) {
            Map val = entry.getValue();
            String name = entry.getKey();
            String addr = this.get("address", "localhost:25565", val);
            String motd = ChatColor.translateAlternateColorCodes('&', this.get("motd", "&1Just another Waterfall - Forced Host", val));
            boolean restricted = this.get("restricted", false, val);
            InetSocketAddress address = Util.getAddr(addr);
            ServerInfo info = ProxyServer.getInstance().constructServerInfo(name, address, motd, restricted);
            ret.put(name, info);
        }
        return ret;
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public Collection<ListenerInfo> getListeners() {
        Collection base = this.get("listeners", Arrays.asList(new HashMap()));
        HashMap<String, String> forcedDef = new HashMap<String, String>();
        forcedDef.put("pvp.md-5.net", "pvp");
        HashSet<ListenerInfo> ret = new HashSet<ListenerInfo>();
        for (Map val : base) {
            String motd = this.get("motd", "&1Another Bungee server", val);
            motd = ChatColor.translateAlternateColorCodes('&', motd);
            int maxPlayers = this.get("max_players", 1, val);
            boolean forceDefault = this.get("force_default_server", false, val);
            String host = this.get("host", "0.0.0.0:25577", val);
            int tabListSize = this.get("tab_size", 60, val);
            InetSocketAddress address = Util.getAddr(host);
            CaseInsensitiveMap<String> forced = new CaseInsensitiveMap<String>(this.get("forced_hosts", forcedDef, val));
            String tabListName = this.get("tab_list", "GLOBAL_PING", val);
            DefaultTabList value = DefaultTabList.valueOf(tabListName.toUpperCase(Locale.ROOT));
            if (value == null) {
                value = DefaultTabList.GLOBAL_PING;
            }
            boolean setLocalAddress = this.get("bind_local_address", true, val);
            boolean pingPassthrough = this.get("ping_passthrough", false, val);
            boolean query = this.get("query_enabled", false, val);
            int queryPort = this.get("query_port", 25577, val);
            boolean proxyProtocol = this.get("proxy_protocol", false, val);
            ArrayList<String> serverPriority = new ArrayList<String>(this.get("priorities", Collections.EMPTY_LIST, val));
            String defaultServer = this.get("default_server", null, val);
            String fallbackServer = this.get("fallback_server", null, val);
            if (defaultServer != null) {
                serverPriority.add(defaultServer);
                this.set("default_server", null, val);
            }
            if (fallbackServer != null) {
                serverPriority.add(fallbackServer);
                this.set("fallback_server", null, val);
            }
            if (serverPriority.isEmpty()) {
                serverPriority.add("lobby");
            }
            this.set("priorities", serverPriority, val);
            ListenerInfo info = new ListenerInfo(address, motd, maxPlayers, tabListSize, serverPriority, forceDefault, forced, value.toString(), setLocalAddress, pingPassthrough, queryPort, query, proxyProtocol);
            ret.add(info);
        }
        return ret;
    }

    @Override
    public Collection<String> getGroups(String player) {
        Collection groups = this.get("groups." + player, null);
        HashSet<String> ret = groups == null ? new HashSet<String>() : new HashSet(groups);
        ret.add("default");
        return ret;
    }

    @Override
    public Collection<?> getList(String path, Collection<?> def) {
        return this.get(path, def);
    }

    @Override
    public Collection<String> getPermissions(String group) {
        Collection permissions = this.get("permissions." + group, null);
        return permissions == null ? Collections.EMPTY_SET : permissions;
    }

    private static enum DefaultTabList {
        GLOBAL,
        GLOBAL_PING,
        SERVER;

    }
}

