/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.event4j.asm;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GeneratedClassLoader
extends ClassLoader {
    private static final ConcurrentMap<ClassLoader, GeneratedClassLoader> loaders = new ConcurrentHashMap<ClassLoader, GeneratedClassLoader>();

    public static GeneratedClassLoader getLoader(ClassLoader parent) {
        return loaders.computeIfAbsent(Objects.requireNonNull(parent, "Null parent class-loader"), GeneratedClassLoader::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> defineClass(String name, byte[] data) {
        name = Objects.requireNonNull(name, "Null name").replace('/', '.');
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            if (this.hasClass(name)) {
                throw new IllegalStateException(name + " already defined");
            }
            Class<?> c = this.define(name, Objects.requireNonNull(data, "Null data"));
            if (!c.getName().equals(name)) {
                throw new IllegalArgumentException("class name " + c.getName() + " != requested name " + name);
            }
            return c;
        }
    }

    protected GeneratedClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> define(String name, byte[] data) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c;
            if (this.hasClass(name)) {
                throw new IllegalStateException("Already has class: " + name);
            }
            try {
                c = this.defineClass(name, data, 0, data.length);
            }
            catch (ClassFormatError e) {
                throw new IllegalArgumentException("Illegal class data", e);
            }
            this.resolveClass(c);
            return c;
        }
    }

    @Override
    public Object getClassLoadingLock(String name) {
        return super.getClassLoadingLock(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasClass(String name) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            try {
                Class.forName(name);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

