/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.event4j.asm;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.techcable.event4j.EventBus;
import net.techcable.event4j.EventExecutor;
import net.techcable.event4j.RegisteredListener;
import net.techcable.event4j.asm.GeneratedClassLoader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ASMEventExecutorFactory
implements EventExecutor.Factory {
    public static final Optional<ASMEventExecutorFactory> INSTANCE;
    private static final String GENERATED_EXECUTOR_BASE_NAME;
    private static final AtomicInteger NEXT_ID;
    private final ConcurrentMap<Method, Class<? extends EventExecutor>> cache = new ConcurrentHashMap<Method, Class<? extends EventExecutor>>();

    protected static Class<? extends EventExecutor> generateExecutor(Method method) {
        Objects.requireNonNull(method, "Null method");
        String name = ASMEventExecutorFactory.generateName();
        byte[] data = ASMEventExecutorFactory.generateEventExecutor(method, name);
        ClassLoader listenerLoader = method.getDeclaringClass().getClassLoader();
        GeneratedClassLoader loader = GeneratedClassLoader.getLoader(Objects.requireNonNull(listenerLoader, "Null class loader for " + method.getDeclaringClass()));
        return loader.defineClass(name, data).asSubclass(EventExecutor.class);
    }

    private static byte[] generateEventExecutor(Method m, String name) {
        ClassWriter writer = new ClassWriter(3);
        writer.visit(52, 1, name, null, "java/lang/Object", new String[]{Type.getInternalName(EventExecutor.class)});
        GeneratorAdapter methodGenerator = new GeneratorAdapter(writer.visitMethod(1, "<init>", "()V", null, null), 1, "<init>", "()V");
        methodGenerator.loadThis();
        methodGenerator.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        methodGenerator.returnValue();
        methodGenerator.endMethod();
        methodGenerator = new GeneratorAdapter(writer.visitMethod(1, "fire", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null), 1, "fire", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        methodGenerator.loadArg(0);
        methodGenerator.checkCast(Type.getType(m.getDeclaringClass()));
        methodGenerator.loadArg(1);
        methodGenerator.checkCast(Type.getType(m.getParameterTypes()[0]));
        methodGenerator.visitMethodInsn(182, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m), m.getDeclaringClass().isInterface());
        if (m.getReturnType() != Void.TYPE) {
            methodGenerator.pop();
        }
        methodGenerator.returnValue();
        methodGenerator.endMethod();
        writer.visitEnd();
        return writer.toByteArray();
    }

    public static String generateName() {
        return GENERATED_EXECUTOR_BASE_NAME.concat(String.valueOf(NEXT_ID.getAndIncrement()));
    }

    @Override
    public <E, L> EventExecutor<E, L> create(EventBus<E, L> eventBus, Method method) {
        RegisteredListener.validate(Objects.requireNonNull(eventBus, "Null eventBus"), Objects.requireNonNull(method, "Null method"));
        Class executorClass = this.cache.computeIfAbsent(method, ASMEventExecutorFactory::generateExecutor);
        try {
            return (EventExecutor)executorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to initialize " + executorClass, e);
        }
    }

    static {
        Optional<Object> instance = Optional.empty();
        try {
            Class.forName("org.objectweb.asm.Opcodes");
            instance = Optional.of(new ASMEventExecutorFactory());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INSTANCE = instance;
        String className = ASMEventExecutorFactory.class.getName().replace('.', '/');
        String packageName = className.substring(0, className.lastIndexOf(47));
        GENERATED_EXECUTOR_BASE_NAME = packageName + "/GeneratedEventExecutor";
        NEXT_ID = new AtomicInteger(1);
    }
}

