/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.event4j;

import java.lang.reflect.Method;
import java.util.Objects;
import net.techcable.event4j.EventBus;
import net.techcable.event4j.EventExecutor;
import net.techcable.event4j.marker.MarkedEvent;

public final class RegisteredListener<E, L>
implements Comparable<RegisteredListener> {
    protected final EventBus<E, L> eventBus;
    protected final L listener;
    protected final Method method;
    private final MarkedEvent marked;
    private final EventExecutor<E, L> executor;

    public RegisteredListener(EventBus<E, L> eventBus, Method method, L listener, EventExecutor<E, L> executor) {
        RegisteredListener.validate(eventBus, method);
        this.eventBus = Objects.requireNonNull(eventBus, "Null eventBus");
        this.method = Objects.requireNonNull(method, "Null method");
        this.listener = Objects.requireNonNull(listener, "Null listener");
        this.executor = Objects.requireNonNull(executor, "Null executor");
        this.marked = Objects.requireNonNull(eventBus.getEventMarker().mark(method), "Null marked event");
    }

    public static <E, L> void validate(EventBus<E, L> eventBus, Method method) {
        Objects.requireNonNull(eventBus, "Null eventBus");
        Objects.requireNonNull(method, "Null method");
        if (!eventBus.getEventMarker().isMarked(method)) {
            throw new IllegalArgumentException("Method must be an event handler: " + method.getDeclaringClass().getName() + "::" + method.getName());
        }
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("EventHandlers must have only one argument: " + method.getDeclaringClass().getName() + "::" + method.getName());
        }
        if (!eventBus.getEventClass().isAssignableFrom(method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("EventHandler must accept one argument: " + method.getParameterTypes()[0].getSimpleName());
        }
        if (!eventBus.getListenerClass().isAssignableFrom(method.getDeclaringClass())) {
            throw new IllegalArgumentException("Listener " + method.getDeclaringClass() + " must be instanceof " + eventBus.getListenerClass());
        }
    }

    public void fire(E event) {
        this.executor.fire(this.listener, event);
    }

    public Class<? extends E> getEventType() {
        return this.method.getParameterTypes()[0].asSubclass(this.eventBus.getEventClass());
    }

    public int getPriority() {
        return this.marked.getPriority();
    }

    public String toString() {
        return this.listener.getClass().getName() + "::" + this.method.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this || obj == null) {
            return false;
        }
        if (obj.getClass() == RegisteredListener.class) {
            RegisteredListener other = (RegisteredListener)obj;
            return other.eventBus == this.eventBus && other.getListener() == this.getListener() && other.getMethod().equals(this.getMethod());
        }
        return false;
    }

    public int hashCode() {
        return this.getMethod().hashCode() ^ this.getListener().hashCode();
    }

    @Override
    public int compareTo(RegisteredListener other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }

    public EventBus<E, L> getEventBus() {
        return this.eventBus;
    }

    public L getListener() {
        return this.listener;
    }

    public Method getMethod() {
        return this.method;
    }
}

