/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.event4j;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.techcable.event4j.EventBus;
import net.techcable.event4j.RegisteredListener;

public class HandlerList<E, L> {
    private final EventBus<E, L> eventBus;
    private final Set<RegisteredListener<E, L>> listenerSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile RegisteredListener[] bakedListeners = null;

    public void fire(E event) {
        for (RegisteredListener<E, L> listener : this.baked()) {
            listener.fire(event);
        }
    }

    public void register(RegisteredListener<E, L> listener) {
        this.listenerSet.add(listener);
        this.bakedListeners = null;
    }

    public void unregister(RegisteredListener listener) {
        this.listenerSet.remove(listener);
        this.bakedListeners = null;
    }

    private RegisteredListener<E, L>[] baked() {
        RegisteredListener[] baked = this.bakedListeners;
        if (baked == null) {
            baked = this.bakeListeners();
        }
        return baked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisteredListener[] bakeListeners() {
        Object[] baked;
        HandlerList handlerList = this;
        synchronized (handlerList) {
            baked = this.bakedListeners;
            if (this.bakedListeners == null) {
                baked = this.listenerSet.toArray(new RegisteredListener[this.listenerSet.size()]);
                Arrays.sort(baked);
                this.bakedListeners = baked;
            }
        }
        return baked;
    }

    public Set<RegisteredListener> getListenerSet() {
        return Collections.unmodifiableSet(this.listenerSet);
    }

    @ConstructorProperties(value={"eventBus"})
    public HandlerList(EventBus<E, L> eventBus) {
        this.eventBus = eventBus;
    }
}

