/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.event4j;

import java.lang.reflect.Method;
import java.util.Optional;
import net.techcable.event4j.EventBus;
import net.techcable.event4j.MHEventExecutor;
import net.techcable.event4j.ReflectionEventExecutor;
import net.techcable.event4j.asm.ASMEventExecutorFactory;

@FunctionalInterface
public interface EventExecutor<E, L> {
    public void fire(L var1, E var2);

    public static <E, L> EventExecutor<E, L> empty() {
        return (listener, event) -> {
            throw new UnsupportedOperationException("Empty event executor");
        };
    }

    @FunctionalInterface
    public static interface Factory {
        public static final Factory METHOD_HANDLE_LISTENER_FACTORY = MHEventExecutor::new;
        public static final Factory REFLECTION_LISTENER_FACTORY = ReflectionEventExecutor::new;
        public static final Optional<Factory> ASM_LISTENER_FACTORY = ASMEventExecutorFactory.INSTANCE;

        public <E, L> EventExecutor<E, L> create(EventBus<E, L> var1, Method var2);

        public static Factory getDefault() {
            return ASM_LISTENER_FACTORY.orElse(METHOD_HANDLE_LISTENER_FACTORY);
        }
    }
}

