/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.event4j;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.techcable.event4j.EventExecutor;
import net.techcable.event4j.EventHandler;
import net.techcable.event4j.HandlerList;
import net.techcable.event4j.RegisteredListener;
import net.techcable.event4j.marker.EventMarker;

public final class EventBus<E, L> {
    private final ConcurrentMap<Class<?>, HandlerList<E, L>> handlers = new ConcurrentHashMap();
    private final EventMarker eventMarker;
    private final EventExecutor.Factory executorFactory;
    private final Class<E> eventClass;
    private final Class<L> listenerClass;

    public void fire(E event) {
        if (event == null) {
            throw new NullPointerException("Null event");
        }
        HandlerList handler = (HandlerList)this.handlers.get(event.getClass());
        if (handler == null) {
            return;
        }
        handler.fire(event);
    }

    public void unregister(L listener) {
        if (!this.listenerClass.isInstance(listener)) {
            throw new IllegalArgumentException("Invalid listener type: " + listener.getClass().getClass());
        }
        for (Method method : listener.getClass().getDeclaredMethods()) {
            if (!this.eventMarker.isMarked(method)) continue;
            RegisteredListener registeredListener = new RegisteredListener(this, method, listener, EventExecutor.empty());
            ((HandlerList)this.handlers.get(registeredListener.getEventType())).unregister(registeredListener);
        }
    }

    public void register(L listener) {
        if (listener == null) {
            throw new NullPointerException("Null listener");
        }
        if (!this.listenerClass.isInstance(listener)) {
            throw new IllegalArgumentException("Invalid listener type: " + listener.getClass().getName());
        }
        for (Method method : listener.getClass().getDeclaredMethods()) {
            if (!this.eventMarker.isMarked(method)) continue;
            RegisteredListener registeredListener = new RegisteredListener(this, method, listener, this.executorFactory.create(this, method));
            this.register(registeredListener);
        }
    }

    private void register(RegisteredListener<E, L> listener) {
        HandlerList handlerList = this.handlers.computeIfAbsent(listener.getEventType(), eventType -> new HandlerList(this));
        handlerList.register(listener);
    }

    public static Builder<Object, Object> builder() {
        return new Builder<Object, Object>();
    }

    public static EventBus build() {
        return EventBus.builder().build();
    }

    private EventBus(EventMarker eventMarker, EventExecutor.Factory executorFactory, Class<E> eventClass, Class<L> listenerClass) {
        this.eventMarker = eventMarker;
        this.executorFactory = executorFactory;
        this.eventClass = eventClass;
        this.listenerClass = listenerClass;
    }

    protected EventMarker getEventMarker() {
        return this.eventMarker;
    }

    public Class<E> getEventClass() {
        return this.eventClass;
    }

    public Class<L> getListenerClass() {
        return this.listenerClass;
    }

    public static class Builder<E, L> {
        private Class<?> eventClass = Object.class;
        private Class<?> listenerClass = Object.class;
        private EventMarker eventMarker = m -> m.isAnnotationPresent(EventHandler.class) ? m.getAnnotation(EventHandler.class).priority()::ordinal : null;
        private EventExecutor.Factory executorFactory = EventExecutor.Factory.getDefault();

        public <E> Builder<E, L> eventClass(Class<E> eventClass) {
            this.eventClass = Objects.requireNonNull(eventClass, "Null event class");
            return this;
        }

        public <L> Builder<E, L> listenerClass(Class<L> listenerClass) {
            this.listenerClass = Objects.requireNonNull(listenerClass, "Null listener class");
            return this;
        }

        public Builder<E, L> eventMarker(EventMarker eventMarker) {
            this.eventMarker = Objects.requireNonNull(eventMarker, "Null event marker");
            return this;
        }

        public Builder<E, L> executorFactory(EventExecutor.Factory factory) {
            this.executorFactory = Objects.requireNonNull(factory, "Null exevutor factory");
            return this;
        }

        public EventBus<E, L> build() {
            return new EventBus(this.eventMarker, this.executorFactory, this.eventClass, this.listenerClass);
        }

        private Builder() {
        }
    }
}

