/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.md_5.bungee.protocol.DefinedPacket;

public class Varint21FrameDecoder
extends ByteToMessageDecoder {
    private static final long EMPTY_PACKET_THROTTLE = Long.parseLong(System.getProperty("waterfall.empty_packet_throttle", Long.toString(200L)));
    private AtomicLong lastEmptyPacket = new AtomicLong(0L);
    private static boolean DIRECT_WARNING;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        byte[] buf = new byte[3];
        for (int i = 0; i < buf.length; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            buf[i] = in.readByte();
            if (buf[i] < 0) continue;
            int length = DefinedPacket.readVarInt(Unpooled.wrappedBuffer(buf));
            if (length == 0) {
                if (EMPTY_PACKET_THROTTLE > 0L) {
                    long lastEmptyPacket;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (lastEmptyPacket = this.lastEmptyPacket.getAndSet(currentTime)) < EMPTY_PACKET_THROTTLE) {
                        throw new CorruptedFrameException("Too many empty packets");
                    }
                } else {
                    throw new CorruptedFrameException("Empty Packet!");
                }
            }
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            if (in.hasMemoryAddress()) {
                out.add(in.slice(in.readerIndex(), length).retain());
                in.skipBytes(length);
            } else {
                if (!DIRECT_WARNING) {
                    DIRECT_WARNING = true;
                    new Throwable("Using a " + in.getClass().getTypeName() + ", not a direct byte buf!").printStackTrace();
                }
                ByteBuf dst = ctx.alloc().directBuffer(length);
                in.readBytes(dst);
                out.add(dst);
            }
            return;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }
}

