/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.LegacyHandshake;
import net.md_5.bungee.protocol.packet.LegacyPing;

public class LegacyDecoder
extends ByteToMessageDecoder {
    private boolean triedForMoreData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!in.isReadable()) {
            return;
        }
        in.markReaderIndex();
        short packetID = in.readUnsignedByte();
        boolean handled = false;
        try {
            if (packetID == 254) {
                LegacyPingType pingType;
                switch (in.readableBytes()) {
                    case 0: {
                        pingType = LegacyPingType.ANCIENT;
                        break;
                    }
                    case 1: {
                        if (in.readUnsignedByte() != 1) {
                            return;
                        }
                        pingType = LegacyPingType.v14_v15;
                        break;
                    }
                    default: 
                }
                out.add(new PacketWrapper(new LegacyPing(pingType != LegacyPingType.ANCIENT), Unpooled.EMPTY_BUFFER));
                handled = true;
            } else if (packetID == 2 && in.isReadable()) {
                in.skipBytes(in.readableBytes());
                out.add(new PacketWrapper(new LegacyHandshake(), Unpooled.EMPTY_BUFFER));
                handled = true;
            }
        }
        catch (RuntimeException ignored) {
            handled = false;
        }
        finally {
            if (!handled) {
                in.resetReaderIndex();
                ctx.pipeline().remove(this);
            }
        }
    }

    public static String readLegacyString(ByteBuf buf) {
        short stringLength = buf.readShort();
        byte[] stringData = new byte[stringLength * 2];
        buf.readBytes(stringData);
        return new String(stringData, Charsets.UTF_16BE);
    }

    static enum LegacyPingType {
        ANCIENT,
        v14_v15,
        v16;

    }
}

