/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import net.md_5.bungee.compress.PacketCompressor;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;

public class ChannelWrapper {
    private final Channel ch;
    private volatile boolean closed;

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
    }

    public void setProtocol(Protocol protocol) {
        this.ch.pipeline().get(MinecraftDecoder.class).setProtocol(protocol);
        this.ch.pipeline().get(MinecraftEncoder.class).setProtocol(protocol);
    }

    public void setVersion(int protocol) {
        this.ch.pipeline().get(MinecraftDecoder.class).setProtocolVersion(protocol);
        this.ch.pipeline().get(MinecraftEncoder.class).setProtocolVersion(protocol);
    }

    public void write(Object packet) {
        if (!this.isClosed()) {
            if (packet instanceof PacketWrapper) {
                ((PacketWrapper)packet).setReleased(true);
                this.ch.writeAndFlush(((PacketWrapper)packet).buf, this.ch.voidPromise());
            } else {
                this.ch.writeAndFlush(packet, this.ch.voidPromise());
            }
        }
    }

    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            this.ch.flush();
            this.ch.close();
        }
    }

    public void close(Object packet) {
        if (!this.isClosed()) {
            this.closed = true;
            this.ch.writeAndFlush(packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE});
        }
    }

    public boolean isClosed() {
        return this.closed || !this.ch.isActive();
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState(this.ch.eventLoop().inEventLoop(), "cannot add handler outside of event loop");
        this.ch.pipeline().flush();
        this.ch.pipeline().addBefore(baseName, name, handler);
    }

    public Channel getHandle() {
        return this.ch;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        if (this.ch.pipeline().get(PacketCompressor.class) == null && compressionThreshold != -1) {
            this.addBefore("packet-encoder", "compress", new PacketCompressor());
        }
        if (compressionThreshold != -1) {
            this.ch.pipeline().get(PacketCompressor.class).setThreshold(compressionThreshold);
        } else {
            this.ch.pipeline().remove("compress");
        }
        if (this.ch.pipeline().get(PacketDecompressor.class) == null && compressionThreshold != -1) {
            this.addBefore("packet-decoder", "decompress", new PacketDecompressor(compressionThreshold));
        }
        if (compressionThreshold == -1) {
            this.ch.pipeline().remove("decompress");
        }
    }
}

