/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.yggdrasil.CompatBridge;
import com.mojang.authlib.yggdrasil.CompatProfile;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerHandshakeEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.jni.cipher.BungeeCipher;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.cipher.CipherDecoder;
import net.md_5.bungee.netty.cipher.CipherEncoder;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.LegacyHandshake;
import net.md_5.bungee.protocol.packet.LegacyPing;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.util.BoundedArrayList;

public class InitialHandler
extends PacketHandler
implements PendingConnection {
    private final BungeeCord bungee;
    private ChannelWrapper ch;
    private final ListenerInfo listener;
    private Handshake handshake;
    private LoginRequest loginRequest;
    private EncryptionRequest request;
    private final List<PluginMessage> registerMessages = new BoundedArrayList<PluginMessage>(128);
    private State thisState = State.HANDSHAKE;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            InitialHandler.this.ch.write(packet);
        }
    };
    private boolean onlineMode;
    private InetSocketAddress virtualHost;
    private UUID uniqueId;
    private UUID offlineId;
    private LoginResult loginProfile;
    private boolean legacy;
    private String extraDataInHandshake;
    private ExecutorService loginExecutor;
    private static final boolean ACCEPT_INVALID_PACKETS = Boolean.parseBoolean(System.getProperty("waterfall.acceptInvalidPackets", "false"));
    public static final boolean LOG_THROTTLED_JOINS = Boolean.parseBoolean(System.getProperty("waterfall.log_throttled_joins", "true"));
    private final AtomicBoolean disconnecting;

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.disconnect((Object)((Object)ChatColor.RED) + Util.exception(t));
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("REGISTER")) {
            this.registerMessages.add(pluginMessage);
        }
    }

    @Override
    public void handle(LegacyHandshake legacyHandshake) throws Exception {
        this.legacy = true;
        this.ch.close(this.bungee.getTranslation("outdated_client", new Object[0]));
    }

    @Override
    public void handle(LegacyPing ping) throws Exception {
        this.legacy = true;
        final boolean v1_5 = ping.isV1_5();
        ServerPing legacy = new ServerPing(new ServerPing.Protocol(this.bungee.getName() + " " + this.bungee.getGameVersion(), this.bungee.getProtocolVersion()), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.getOnlineCount(), null), new TextComponent(TextComponent.fromLegacyText(this.listener.getMotd())), (Favicon)null);
        Callback<ProxyPingEvent> callback = new Callback<ProxyPingEvent>(){

            @Override
            public void done(ProxyPingEvent result, Throwable error) {
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                ServerPing legacy = result.getResponse();
                String kickMessage = v1_5 ? (Object)((Object)ChatColor.DARK_BLUE) + "\u0000" + 127 + '\u0000' + legacy.getVersion().getName() + '\u0000' + InitialHandler.getFirstLine(legacy.getDescription()) + '\u0000' + legacy.getPlayers().getOnline() + '\u0000' + legacy.getPlayers().getMax() : ChatColor.stripColor(InitialHandler.getFirstLine(legacy.getDescription())) + '\u00a7' + legacy.getPlayers().getOnline() + '\u00a7' + legacy.getPlayers().getMax();
                InitialHandler.this.ch.close(kickMessage);
            }
        };
        this.bungee.getPluginManager().callEvent(new ProxyPingEvent(this, legacy, callback));
    }

    private static String getFirstLine(String str) {
        int pos = str.indexOf(10);
        return pos == -1 ? str : str.substring(0, pos);
    }

    @Override
    public void handle(StatusRequest statusRequest) throws Exception {
        Preconditions.checkState(this.thisState == State.STATUS, "Not expecting STATUS");
        ServerInfo forced = AbstractReconnectHandler.getForcedHost(this);
        String motd = forced != null ? forced.getMotd() : this.listener.getMotd();
        Callback<ServerPing> pingBack = new Callback<ServerPing>(){

            @Override
            public void done(ServerPing result, Throwable error) {
                if (error != null) {
                    result = new ServerPing();
                    result.setDescription(InitialHandler.this.bungee.getTranslation("ping_cannot_connect", new Object[0]));
                    InitialHandler.this.bungee.getLogger().log(Level.WARNING, "Error pinging remote server", error);
                }
                Callback<ProxyPingEvent> callback = new Callback<ProxyPingEvent>(){

                    @Override
                    public void done(ProxyPingEvent pingResult, Throwable error) {
                        Gson gson;
                        Gson gson2 = gson = InitialHandler.this.handshake.getProtocolVersion() == 4 ? BungeeCord.getInstance().gsonLegacy : BungeeCord.getInstance().gson;
                        if (InitialHandler.this.handshake.getProtocolVersion() < 107) {
                            JsonElement element = gson.toJsonTree(pingResult.getResponse());
                            Preconditions.checkArgument(element.isJsonObject(), "Response is not a JSON object");
                            JsonObject object = element.getAsJsonObject();
                            object.addProperty("description", pingResult.getResponse().getDescription());
                            InitialHandler.this.unsafe.sendPacket(new StatusResponse(gson.toJson(element)));
                        } else {
                            InitialHandler.this.unsafe.sendPacket(new StatusResponse(gson.toJson(pingResult.getResponse())));
                        }
                    }
                };
                InitialHandler.this.bungee.getPluginManager().callEvent(new ProxyPingEvent(InitialHandler.this, result, callback));
            }
        };
        if (forced != null && this.listener.isPingPassthrough()) {
            ((BungeeServerInfo)forced).ping(pingBack, this.handshake.getProtocolVersion());
        } else {
            int protocol = ProtocolConstants.SUPPORTED_VERSION_IDS.contains(this.handshake.getProtocolVersion()) ? this.handshake.getProtocolVersion() : this.bungee.getProtocolVersion();
            pingBack.done(new ServerPing(new ServerPing.Protocol(this.bungee.getName() + " " + this.bungee.getGameVersion(), protocol), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.getOnlineCount(), null), motd, BungeeCord.getInstance().config.getFaviconObject()), null);
        }
        this.thisState = State.PING;
    }

    @Override
    public void handle(PingPacket ping) throws Exception {
        if (!ACCEPT_INVALID_PACKETS) {
            Preconditions.checkState(this.thisState == State.PING, "Not expecting PING");
        }
        this.ch.close(ping);
    }

    @Override
    public void handle(Handshake handshake) throws Exception {
        Preconditions.checkState(this.thisState == State.HANDSHAKE, "Not expecting HANDSHAKE");
        this.handshake = handshake;
        this.ch.setVersion(handshake.getProtocolVersion());
        if (handshake.getHost().contains("\u0000")) {
            String[] split = handshake.getHost().split("\u0000", 2);
            handshake.setHost(split[0]);
            this.extraDataInHandshake = "\u0000" + split[1];
        }
        if (handshake.getHost().endsWith(".")) {
            handshake.setHost(handshake.getHost().substring(0, handshake.getHost().length() - 1));
        }
        this.virtualHost = InetSocketAddress.createUnresolved(handshake.getHost(), handshake.getPort());
        this.bungee.getPluginManager().callEvent(new PlayerHandshakeEvent(this, handshake));
        switch (handshake.getRequestedProtocol()) {
            case 1: {
                if (BungeeCord.getInstance().getConfig().isLogServerListPing()) {
                    this.bungee.getLogger().log(Level.INFO, "{0} is pinging", this);
                }
                this.thisState = State.STATUS;
                this.ch.setProtocol(Protocol.STATUS);
                break;
            }
            case 2: {
                this.bungee.getLogger().log(Level.INFO, "{0} has connected", this);
                this.thisState = State.USERNAME;
                this.ch.setProtocol(Protocol.LOGIN);
                if (!ProtocolConstants.SUPPORTED_VERSION_IDS.contains(handshake.getProtocolVersion())) {
                    this.disconnect(this.bungee.getTranslation("outdated_server", new Object[0]));
                    return;
                }
                if (this.bungee.getJoinThrottle() == null || !this.bungee.getJoinThrottle().throttle(this.getAddress().getAddress())) break;
                if (LOG_THROTTLED_JOINS) {
                    BungeeCord.getInstance().getLogger().log(Level.INFO, "{0} was join-throttled", this.getAddress().getHostString());
                }
                this.disconnect(this.bungee.getTranslation("join_throttle_kick", TimeUnit.MILLISECONDS.toSeconds(this.bungee.getConfig().getThrottle())));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot request protocol " + handshake.getRequestedProtocol());
            }
        }
    }

    @Override
    public void handle(LoginRequest loginRequest) throws Exception {
        Preconditions.checkState(this.thisState == State.USERNAME, "Not expecting USERNAME");
        this.loginRequest = loginRequest;
        if (!ProtocolConstants.SUPPORTED_VERSION_IDS.contains(this.handshake.getProtocolVersion())) {
            this.disconnect(this.bungee.getTranslation("outdated_server", new Object[0]));
            return;
        }
        if (this.getName().contains(".")) {
            this.disconnect(this.bungee.getTranslation("name_invalid", new Object[0]));
            return;
        }
        if (this.getName().length() > 16) {
            this.disconnect(this.bungee.getTranslation("name_too_long", new Object[0]));
            return;
        }
        int limit = BungeeCord.getInstance().config.getPlayerLimit();
        if (limit > 0 && this.bungee.getOnlineCount() > limit) {
            this.disconnect(this.bungee.getTranslation("proxy_full", new Object[0]));
            return;
        }
        if (!this.isOnlineMode() && this.bungee.getPlayer(this.getUniqueId()) != null) {
            this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            return;
        }
        Callback<PreLoginEvent> callback = new Callback<PreLoginEvent>(){

            @Override
            public void done(PreLoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    InitialHandler.this.disconnect(result.getCancelReason());
                    return;
                }
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                if (InitialHandler.this.onlineMode) {
                    InitialHandler.this.unsafe().sendPacket(InitialHandler.this.request = EncryptionUtil.encryptRequest());
                } else {
                    InitialHandler.this.finish();
                }
                InitialHandler.this.thisState = State.ENCRYPT;
            }
        };
        this.bungee.getPluginManager().callEvent(new PreLoginEvent(this, callback));
    }

    @Override
    public void handle(EncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT, "Not expecting ENCRYPT");
        SecretKey sharedKey = EncryptionUtil.getSecret(encryptResponse, this.request);
        BungeeCipher decrypt = EncryptionUtil.getCipher(false, sharedKey);
        this.ch.addBefore("frame-decoder", "decrypt", new CipherDecoder(decrypt));
        BungeeCipher encrypt = EncryptionUtil.getCipher(true, sharedKey);
        this.ch.addBefore("frame-prepender", "encrypt", new CipherEncoder(encrypt));
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        for (byte[] bit : new byte[][]{this.request.getServerId().getBytes("ISO_8859_1"), sharedKey.getEncoded(), EncryptionUtil.keys.getPublic().getEncoded()}) {
            sha.update(bit);
        }
        String username = this.getName();
        String serverID = new BigInteger(sha.digest()).toString(16);
        this.loginExecutor.submit(() -> {
            try {
                CompatProfile properties = CompatBridge.checkServer((String)username, (String)serverID);
                if (properties == null) {
                    this.disconnect("Bad Login (Serverside)");
                    return;
                }
                this.uniqueId = properties.uuid;
                this.loginProfile = new LoginResult(properties);
                this.finish();
            }
            catch (Exception e) {
                this.disconnect("Authentication failed");
                this.bungee.getLogger().log(Level.SEVERE, "Error authenticating " + username + " with Launcher", e);
            }
        });
    }

    private void finish() {
        ProxiedPlayer oldName;
        if (this.isOnlineMode()) {
            ProxiedPlayer oldID;
            oldName = this.bungee.getPlayer(this.getName());
            if (oldName != null) {
                oldName.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            }
            if ((oldID = this.bungee.getPlayer(this.getUniqueId())) != null) {
                oldID.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            }
        } else {
            oldName = this.bungee.getPlayer(this.getName());
            if (oldName != null) {
                this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
                return;
            }
        }
        this.offlineId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(Charsets.UTF_8));
        if (this.uniqueId == null) {
            this.uniqueId = this.offlineId;
        }
        Callback<LoginEvent> complete = new Callback<LoginEvent>(){

            @Override
            public void done(LoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    InitialHandler.this.disconnect(result.getCancelReason());
                    return;
                }
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                InitialHandler.this.ch.getHandle().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (InitialHandler.this.ch.getHandle().isActive()) {
                            UserConnection userCon = new UserConnection(InitialHandler.this.bungee, InitialHandler.this.ch, InitialHandler.this.getName(), InitialHandler.this);
                            userCon.setCompressionThreshold(BungeeCord.getInstance().config.getCompressionThreshold());
                            userCon.init();
                            if (InitialHandler.this.getVersion() >= 5) {
                                InitialHandler.this.unsafe.sendPacket(new LoginSuccess(InitialHandler.this.getUniqueId().toString(), InitialHandler.this.getName()));
                            } else {
                                InitialHandler.this.unsafe.sendPacket(new LoginSuccess(InitialHandler.this.getUUID(), InitialHandler.this.getName()));
                            }
                            InitialHandler.this.ch.setProtocol(Protocol.GAME);
                            InitialHandler.this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new UpstreamBridge(InitialHandler.this.bungee, userCon));
                            InitialHandler.this.bungee.getPluginManager().callEvent(new PostLoginEvent(userCon));
                            ServerInfo server = InitialHandler.this.bungee.getReconnectHandler() != null ? InitialHandler.this.bungee.getReconnectHandler().getServer(userCon) : AbstractReconnectHandler.getForcedHost(InitialHandler.this);
                            if (server == null) {
                                server = InitialHandler.this.bungee.getServerInfo(InitialHandler.this.listener.getDefaultServer());
                            }
                            userCon.connect(server, null, true);
                            InitialHandler.this.thisState = State.FINISHED;
                        }
                    }
                });
            }
        };
        this.bungee.getPluginManager().callEvent(new LoginEvent(this, complete));
    }

    @Override
    public void disconnect(String reason) {
        this.disconnect(TextComponent.fromLegacyText(reason));
    }

    @Override
    public boolean shouldHandle(PacketWrapper p) {
        return !this.disconnecting.get();
    }

    @Override
    public void disconnect(BaseComponent ... reason) {
        if (!this.disconnecting.compareAndSet(false, true)) {
            return;
        }
        if (!this.ch.isClosed()) {
            if (this.thisState != State.STATUS && this.thisState != State.PING) {
                this.ch.close(new Kick(ComponentSerializer.toString(reason)));
            } else {
                this.ch.close();
            }
        }
    }

    @Override
    public void disconnect(BaseComponent reason) {
        this.disconnect(new BaseComponent[]{reason});
    }

    @Override
    public String getName() {
        return this.loginRequest == null ? null : this.loginRequest.getData();
    }

    @Override
    public int getVersion() {
        return this.handshake == null ? -1 : this.handshake.getProtocolVersion();
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public void setOnlineMode(boolean onlineMode) {
        Preconditions.checkState(this.thisState == State.USERNAME, "Can only set online mode status whilst state is username");
        this.onlineMode = onlineMode;
    }

    @Override
    public void setUniqueId(UUID uuid) {
        Preconditions.checkState(this.thisState == State.USERNAME, "Can only set uuid while state is username");
        Preconditions.checkState(!this.onlineMode, "Can only set uuid when online mode is false");
        this.uniqueId = uuid;
    }

    @Override
    public String getUUID() {
        return Util.getMojangUUID(this.uniqueId);
    }

    @Override
    public String toString() {
        return "[" + this.getAddress() + (this.getName() != null ? "|" + this.getName() : "") + "] <-> InitialHandler";
    }

    @Override
    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    @ConstructorProperties(value={"bungee", "listener"})
    public InitialHandler(BungeeCord bungee, ListenerInfo listener) {
        this.onlineMode = BungeeCord.getInstance().config.isOnlineMode();
        this.extraDataInHandshake = "";
        this.loginExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Login Thread #%1$d").setDaemon(true).build());
        this.disconnecting = new AtomicBoolean(false);
        this.bungee = bungee;
        this.listener = listener;
    }

    @Override
    public ListenerInfo getListener() {
        return this.listener;
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public LoginRequest getLoginRequest() {
        return this.loginRequest;
    }

    public List<PluginMessage> getRegisterMessages() {
        return this.registerMessages;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public UUID getOfflineId() {
        return this.offlineId;
    }

    public LoginResult getLoginProfile() {
        return this.loginProfile;
    }

    @Override
    public boolean isLegacy() {
        return this.legacy;
    }

    public String getExtraDataInHandshake() {
        return this.extraDataInHandshake;
    }

    private static enum State {
        HANDSHAKE(false),
        STATUS(false),
        PING(false),
        USERNAME(true),
        ENCRYPT(true),
        FINISHED(true);

        private final boolean allowKickPackets;

        public boolean isAllowKickPackets() {
            return this.allowKickPackets;
        }

        private State(boolean allowKickPackets) {
            this.allowKickPackets = allowKickPackets;
        }
    }
}

