/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Configuration {
    private static final char SEPARATOR = '.';
    final Map<String, Object> self;
    private final Configuration defaults;

    public Configuration() {
        this(null);
    }

    public Configuration(Configuration defaults) {
        this(new LinkedHashMap<String, Object>(), defaults);
    }

    private Configuration getSectionFor(String path) {
        int index = path.indexOf(46);
        if (index == -1) {
            return this;
        }
        String root = path.substring(0, index);
        LinkedHashMap section = this.self.get(root);
        if (section == null) {
            section = new LinkedHashMap();
            this.self.put(root, section);
        }
        if (section instanceof Configuration) {
            return (Configuration)((Object)section);
        }
        return new Configuration(section, this.defaults == null ? null : this.defaults.getSectionFor(path));
    }

    private String getChild(String path) {
        int index = path.indexOf(46);
        return index == -1 ? path : path.substring(index + 1);
    }

    public <T> T get(String path, T def) {
        Configuration section = this.getSectionFor(path);
        Object val = section == this ? this.self.get(path) : section.get(this.getChild(path), def);
        return (T)(val != null ? val : def);
    }

    public <T> T get(String path) {
        T def = this.getDefault(path);
        return this.get(path, def);
    }

    public <T> T getDefault(String path) {
        return this.defaults == null ? null : (T)this.defaults.get(path);
    }

    public void set(String path, Object value) {
        Configuration section = this.getSectionFor(path);
        if (section == this) {
            if (value == null) {
                this.self.remove(path);
            } else {
                this.self.put(path, value);
            }
        } else {
            section.set(this.getChild(path), value);
        }
    }

    public Configuration getSection(String path) {
        Map def = (Map)this.getDefault(path);
        return new Configuration(this.get(path, def != null ? def : Collections.emptyMap()), this.defaults == null ? null : this.defaults.getSection(path));
    }

    public Collection<String> getKeys() {
        return Sets.newLinkedHashSet(this.self.keySet());
    }

    public byte getByte(String path) {
        Number def = (Number)this.getDefault(path);
        return this.getByte(path, def != null ? def.byteValue() : (byte)0);
    }

    public byte getByte(String path, byte def) {
        return this.get(path, def);
    }

    public List<Byte> getByteList(String path) {
        List list = this.getList(path);
        ArrayList<Byte> result = new ArrayList<Byte>(list.size());
        for (Number number : list) {
            result.add(number.byteValue());
        }
        return result;
    }

    public short getShort(String path) {
        Number def = (Number)this.getDefault(path);
        return this.getShort(path, def != null ? def.shortValue() : (short)0);
    }

    public short getShort(String path, short def) {
        Number val = this.get(path, def);
        return val != null ? val.shortValue() : def;
    }

    public List<Short> getShortList(String path) {
        List list = this.getList(path);
        ArrayList<Short> result = new ArrayList<Short>();
        for (Number number : list) {
            result.add(number.shortValue());
        }
        return result;
    }

    public int getInt(String path) {
        Number def = (Number)this.getDefault(path);
        return this.getInt(path, def != null ? def.intValue() : 0);
    }

    public int getInt(String path, int def) {
        Number val = this.get(path, def);
        return val != null ? val.intValue() : def;
    }

    public List<Integer> getIntList(String path) {
        List list = this.getList(path);
        ArrayList<Integer> result = new ArrayList<Integer>(list.size());
        for (Number number : list) {
            result.add(number.intValue());
        }
        return result;
    }

    public long getLong(String path) {
        Number def = (Number)this.getDefault(path);
        return this.getLong(path, def != null ? def.longValue() : 0L);
    }

    public long getLong(String path, long def) {
        Number val = this.get(path, def);
        return val != null ? val.longValue() : def;
    }

    public List<Long> getLongList(String path) {
        List list = this.getList(path);
        ArrayList<Long> result = new ArrayList<Long>();
        for (Number number : list) {
            result.add(number.longValue());
        }
        return result;
    }

    public float getFloat(String path) {
        Object def = this.getDefault(path);
        return this.getFloat(path, def instanceof Number ? ((Number)def).floatValue() : 0.0f);
    }

    public float getFloat(String path, float def) {
        Number val = this.get(path, Float.valueOf(def));
        return val != null ? val.floatValue() : def;
    }

    public List<Float> getFloatList(String path) {
        List list = this.getList(path);
        ArrayList<Float> result = new ArrayList<Float>();
        for (Number number : list) {
            result.add(Float.valueOf(number.floatValue()));
        }
        return result;
    }

    public double getDouble(String path) {
        Number def = (Number)this.getDefault(path);
        return this.getDouble(path, def != null ? def.doubleValue() : 0.0);
    }

    public double getDouble(String path, double def) {
        Number val = this.get(path, def);
        return val != null ? val.doubleValue() : def;
    }

    public List<Double> getDoubleList(String path) {
        List list = this.getList(path);
        ArrayList<Double> result = new ArrayList<Double>(list.size());
        for (Number number : list) {
            result.add(number.doubleValue());
        }
        return result;
    }

    public boolean getBoolean(String path) {
        Boolean def = (Boolean)this.getDefault(path);
        return this.getBoolean(path, def != null ? def : false);
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean val = this.get(path, def);
        return val != null ? val : def;
    }

    public List<Boolean> getBooleanList(String path) {
        List list = this.getList(path);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Boolean bool : list) {
            result.add(bool);
        }
        return result;
    }

    public char getChar(String path) {
        Character def = (Character)this.getDefault(path);
        return this.getChar(path, def != null ? def.charValue() : (char)'\u0000');
    }

    public char getChar(String path, char def) {
        Character val = this.get(path, Character.valueOf(def));
        return val != null ? val.charValue() : def;
    }

    public List<Character> getCharList(String path) {
        List list = this.getList(path);
        ArrayList<Character> result = new ArrayList<Character>();
        for (Character character : list) {
            result.add(character);
        }
        return result;
    }

    public String getString(String path) {
        Object def = this.getDefault(path);
        return this.getString(path, def instanceof String ? (String)def : "");
    }

    public String getString(String path, String def) {
        String val = this.get(path, def);
        return val != null ? val : def;
    }

    public List<String> getStringList(String path) {
        List list = this.getList(path);
        ArrayList<String> result = new ArrayList<String>();
        for (String string : list) {
            result.add(string);
        }
        return result;
    }

    public <T> List<T> getList(String path) {
        List def = (List)this.getDefault(path);
        return this.getList(path, def != null ? def : Collections.emptyList());
    }

    public <T> List<T> getList(String path, List<T> def) {
        return MoreObjects.firstNonNull(this.get(path, def), def);
    }

    Configuration(Map<String, Object> self, Configuration defaults) {
        this.self = self;
        this.defaults = defaults;
    }
}

