/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.conf;

import com.google.common.base.Preconditions;
import gnu.trove.map.TMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyConfig;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.util.CaseInsensitiveMap;
import net.md_5.bungee.util.CaseInsensitiveSet;

public abstract class Configuration
implements ProxyConfig {
    private int timeout = 30000;
    private String uuid = UUID.randomUUID().toString();
    private Collection<ListenerInfo> listeners;
    private TMap<String, ServerInfo> servers;
    private boolean onlineMode = true;
    private boolean logCommands;
    private int playerLimit = -1;
    private Collection<String> disabledCommands;
    private boolean ipForward;
    private Favicon favicon;
    private int compressionThreshold = 256;

    public void load() {
        ConfigurationAdapter adapter = ProxyServer.getInstance().getConfigurationAdapter();
        adapter.load();
        File fav = new File("server-icon.png");
        if (fav.exists()) {
            try {
                this.favicon = Favicon.create(ImageIO.read(fav));
            }
            catch (IOException | IllegalArgumentException ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load server icon", ex);
            }
        }
        this.listeners = adapter.getListeners();
        this.timeout = adapter.getInt("timeout", this.timeout);
        this.uuid = adapter.getString("stats", this.uuid);
        this.onlineMode = adapter.getBoolean("online_mode", this.onlineMode);
        this.logCommands = adapter.getBoolean("log_commands", this.logCommands);
        this.playerLimit = adapter.getInt("player_limit", this.playerLimit);
        this.ipForward = adapter.getBoolean("ip_forward", this.ipForward);
        this.compressionThreshold = adapter.getInt("network_compression_threshold", this.compressionThreshold);
        this.disabledCommands = new CaseInsensitiveSet(adapter.getList("disabled_commands", Arrays.asList("disabledcommandhere")));
        Preconditions.checkArgument(this.listeners != null && !this.listeners.isEmpty(), "No listeners defined.");
        Map<String, ServerInfo> newServers = adapter.getServers();
        Preconditions.checkArgument(newServers != null && !newServers.isEmpty(), "No servers defined");
        if (this.servers == null) {
            this.servers = new CaseInsensitiveMap<ServerInfo>(newServers);
        } else {
            TMap<String, ServerInfo> oldServers = this.servers;
            this.servers = new CaseInsensitiveMap<ServerInfo>(newServers);
            for (ServerInfo oldServer : oldServers.values()) {
                ServerInfo newServer = newServers.get(oldServer.getName());
                if (newServer != null && oldServer.getAddress().equals(newServer.getAddress()) || oldServer.getPlayers().isEmpty()) continue;
                BungeeCord.getInstance().getLogger().info("Moving players off of server: " + oldServer.getName());
                for (ProxiedPlayer player : oldServer.getPlayers()) {
                    ListenerInfo listener = player.getPendingConnection().getListener();
                    String destinationName = newServers.get(listener.getDefaultServer()) == null ? listener.getDefaultServer() : listener.getFallbackServer();
                    ServerInfo destination = newServers.get(destinationName);
                    if (destination == null) {
                        BungeeCord.getInstance().getLogger().severe("Couldn't find server " + listener.getDefaultServer() + " or " + listener.getFallbackServer() + " to put player " + player.getName() + " on");
                        player.disconnect(BungeeCord.getInstance().getTranslation("fallback_kick", "Not found on reload"));
                        continue;
                    }
                    player.connect(destination, (success, cause) -> {
                        if (!success.booleanValue()) {
                            BungeeCord.getInstance().getLogger().log(Level.WARNING, "Failed to connect " + player.getName() + " to " + destination.getName(), cause);
                            player.disconnect(BungeeCord.getInstance().getTranslation("fallback_kick", cause.getCause().getClass().getName()));
                        }
                    });
                }
            }
        }
        for (ListenerInfo listener : this.listeners) {
            for (int i = 0; i < listener.getServerPriority().size(); ++i) {
                String server = listener.getServerPriority().get(i);
                Preconditions.checkArgument(this.servers.containsKey(server), "Server %s (priority %s) is not defined", server, i);
            }
            for (String server : listener.getForcedHosts().values()) {
                if (this.servers.containsKey(server)) continue;
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Forced host server {0} is not defined", server);
            }
        }
    }

    @Override
    @Deprecated
    public String getFavicon() {
        return this.getFaviconObject().getEncoded();
    }

    @Override
    public Favicon getFaviconObject() {
        return this.favicon;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public Collection<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public TMap<String, ServerInfo> getServers() {
        return this.servers;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public boolean isLogCommands() {
        return this.logCommands;
    }

    @Override
    public int getPlayerLimit() {
        return this.playerLimit;
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.disabledCommands;
    }

    @Override
    public boolean isIpForward() {
        return this.ipForward;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }
}

