/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class ServerConnection
implements Server {
    private final ChannelWrapper ch;
    private final BungeeServerInfo info;
    private boolean isObsolete;
    private final boolean forgeServer = false;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            ServerConnection.this.ch.write(packet);
        }
    };

    @Override
    public void sendData(String channel, byte[] data) {
        this.unsafe().sendPacket(new PluginMessage(channel, data, false));
    }

    @Override
    public void disconnect(String reason) {
        this.disconnect(new BaseComponent[0]);
    }

    @Override
    public void disconnect(BaseComponent ... reason) {
        Preconditions.checkArgument(reason.length == 0, "Server cannot have disconnect reason");
        if (!this.ch.isClosed()) {
            this.ch.getHandle().eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    ServerConnection.this.ch.close();
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void disconnect(BaseComponent reason) {
        this.disconnect(new BaseComponent[0]);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getInfo().getAddress();
    }

    @Override
    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @ConstructorProperties(value={"ch", "info"})
    public ServerConnection(ChannelWrapper ch, BungeeServerInfo info) {
        this.ch = ch;
        this.info = info;
    }

    public ChannelWrapper getCh() {
        return this.ch;
    }

    @Override
    public BungeeServerInfo getInfo() {
        return this.info;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    public boolean isForgeServer() {
        return this.forgeServer;
    }
}

