/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConnectionThrottle {
    private final long throttleTime;
    private final Map<InetAddress, Long> throttle = new LinkedHashMap<InetAddress, Long>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetAddress, Long> eldest) {
            return System.currentTimeMillis() - ConnectionThrottle.this.throttleTime >= eldest.getValue();
        }
    };

    public boolean throttle(InetAddress address) {
        long currentTime = System.currentTimeMillis();
        Long value = this.throttle.put(address, currentTime);
        return value != null && currentTime - value < this.throttleTime;
    }

    @ConstructorProperties(value={"throttleTime"})
    public ConnectionThrottle(long throttleTime) {
        this.throttleTime = throttleTime;
    }
}

