/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall.utils;

import com.google.common.base.Preconditions;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class LowMemorySet<T extends Comparable<T>>
extends AbstractSet<T>
implements Set<T> {
    private final List<T> backing;
    private boolean trimAggressively;

    protected LowMemorySet(List<T> list) {
        this.backing = Preconditions.checkNotNull(list, "Null list");
        this.sort();
        this.trim(true);
    }

    public static <T extends Comparable<T>> LowMemorySet<T> create() {
        return new LowMemorySet(new ArrayList());
    }

    public static <T extends Comparable<T>> LowMemorySet<T> copyOf(Collection<T> c) {
        return new LowMemorySet<T>(new ArrayList<T>(c));
    }

    private int indexOf(Object o) {
        return Collections.binarySearch(this.backing, o);
    }

    private void sort() {
        this.backing.sort(null);
        this.trim();
    }

    private void trim() {
        this.trim(false);
    }

    private void trim(boolean force) {
        if (this.backing instanceof ArrayList && force || this.trimAggressively) {
            ((ArrayList)this.backing).trimToSize();
        }
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> backing = this.backing.iterator();
        return new Iterator<T>(){
            private T last;

            @Override
            public boolean hasNext() {
                return backing.hasNext();
            }

            @Override
            public T next() {
                this.last = (Comparable)backing.next();
                return this.last;
            }

            @Override
            public void remove() {
                LowMemorySet.this.remove(this.last);
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                backing.forEachRemaining(action);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.backing.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.backing.toArray(a);
    }

    @Override
    public boolean add(T t) {
        if (this.contains(t)) {
            return false;
        }
        this.backing.add(t);
        this.sort();
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Comparable old = (Comparable)this.backing.remove(this.indexOf(o));
        this.trim();
        assert (old == o);
        return old != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int oldSize = this.size();
        boolean result = this.backing.removeIf(c::contains);
        this.trim(oldSize - this.size() > 10);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int oldSize = this.size();
        boolean result = this.backing.removeIf((? super E o) -> !c.contains(o));
        this.trim(oldSize - this.size() > 10);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.containsAll(c)) {
            return false;
        }
        this.backing.addAll(c);
        this.sort();
        return true;
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.trim(true);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.backing.forEach(action);
    }

    @Override
    public Stream<T> stream() {
        return this.backing.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.backing.parallelStream();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        int oldSize = this.size();
        boolean worked = this.backing.removeIf(filter);
        this.trim(this.size() - oldSize > 10);
        return worked;
    }

    public void setTrimAggressively(boolean trimAggressively) {
        this.trimAggressively = trimAggressively;
    }
}

