/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall.conf;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.conf.Configuration;
import net.md_5.bungee.conf.YamlConfig;
import net.md_5.bungee.protocol.ProtocolConstants;

public class WaterfallConfiguration
extends Configuration {
    private int tabThrottle = (int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
    private int joinThrottle = (int)TimeUnit.MILLISECONDS.convert(4L, TimeUnit.SECONDS);
    private boolean metrics = true;
    private boolean logServerListPing = false;
    private String gameVersion;

    @Override
    public void load() {
        super.load();
        YamlConfig config = new YamlConfig(new File("waterfall.yml"));
        config.load(false);
        this.tabThrottle = config.getInt("throttling.tab_complete", this.tabThrottle);
        this.joinThrottle = config.getInt("throttling.join", this.joinThrottle);
        this.metrics = config.getBoolean("metrics", this.metrics);
        this.logServerListPing = config.getBoolean("log_server_list_ping", this.logServerListPing);
        this.gameVersion = config.getString("game_version", Joiner.on(", ").join(ProtocolConstants.SUPPORTED_VERSIONS));
    }

    @Override
    public long getTabThrottle() {
        return this.tabThrottle;
    }

    @Override
    public long getJoinThrottle() {
        return this.joinThrottle;
    }

    @Override
    public boolean isMetrics() {
        return this.metrics;
    }

    @Override
    public boolean isLogServerListPing() {
        return this.logServerListPing;
    }

    @Override
    public String getGameVersion() {
        return this.gameVersion;
    }
}

