/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.logging.log4j.Level;

public class GameData {
    private static final int MIN_BLOCK_ID = 0;
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MIN_POTION_ID = 0;
    private static final int MAX_POTION_ID = 255;
    private static final int MIN_BIOME_ID = 0;
    private static final int MAX_BIOME_ID = 255;
    private static final int MIN_SOUND_ID = 0;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MIN_POTIONTYPE_ID = 0;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MIN_ENCHANTMENT_ID = 0;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final kl BLOCK_TO_ITEM = new kl("minecraft:blocktoitemmap");
    private static final kl BLOCKSTATE_TO_ID = new kl("minecraft:blockstatetoid");
    private static final GameData mainData = new GameData();
    private final FMLControlledNamespacedRegistry<ajt> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, ajt.class, new kl("minecraft:air"), 0, 4095, true, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<ado> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, ado.class, null, 4096, 31999, true, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<rk> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, rk.class, null, 0, 255, false, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<aig> iBiomeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BIOMES, aig.class, null, 0, 255, false, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<ng> iSoundEventRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.SOUNDEVENTS, ng.class, null, 0, 0x3FFFFFF, false, null, null, null);
    private final FMLControlledNamespacedRegistry<afe> iPotionTypeRegistry;
    private final FMLControlledNamespacedRegistry<agm> iEnchantmentRegistry;

    public GameData() {
        kl WATER = new kl("water");
        this.iPotionTypeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONTYPES, afe.class, WATER, 0, 0x3FFFFFF, false, null, null, null);
        this.iEnchantmentRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ENCHANTMENTS, agm.class, null, 0, 32766, false, null, null, null);
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<ajt> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<ado> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<rk> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<aig> getBiomeRegistry() {
        return GameData.getMain().iBiomeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<ng> getSoundEventRegistry() {
        return GameData.getMain().iSoundEventRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<afe> getPotionTypesRegistry() {
        return GameData.getMain().iPotionTypeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<agm> getEnchantmentRegistry() {
        return GameData.getMain().iEnchantmentRegistry;
    }

    @Deprecated
    static ado findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new kl(modId, name));
    }

    @Deprecated
    static ajt findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new kl(modId, name));
    }

    protected static GameData getMain() {
        return mainData;
    }

    @Deprecated
    int registerItem(ado item, String name) {
        return this.iItemRegistry.add(-1, this.addPrefix(name), item);
    }

    @Deprecated
    int registerBlock(ajt block, String name) {
        return this.iBlockRegistry.add(-1, this.addPrefix(name), block);
    }

    private kl addPrefix(String name) {
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc2 = Loader.instance().activeModContainer();
        String prefix = mc2 != null ? mc2.getModId().toLowerCase() : "minecraft";
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            FMLLog.bigWarning("Dangerous alternative prefix %s for name %s, invalid registry invocation/invalid name?", prefix, name);
            prefix = oldPrefix;
        }
        return new kl(prefix, name);
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        kl nameToSubstitute = new kl(name);
        BiMap<ajt, ado> blockItemMap = GameData.getBlockItemMap();
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (ajt)toReplace);
            ajt orig = this.iBlockRegistry.activateSubstitution(nameToSubstitute);
            if (blockItemMap.containsKey((Object)orig)) {
                ado i = (ado)blockItemMap.get((Object)orig);
                blockItemMap.forcePut((Object)((ajt)toReplace), (Object)i);
            }
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (ado)toReplace);
            ado orig = this.iItemRegistry.activateSubstitution(nameToSubstitute);
            if (blockItemMap.containsValue((Object)orig)) {
                ajt b2 = (ajt)blockItemMap.inverse().get((Object)orig);
                blockItemMap.forcePut((Object)b2, (Object)((ado)toReplace));
            }
        }
    }

    public static BiMap<ajt, ado> getBlockItemMap() {
        return GameData.getMain().iItemRegistry.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object, kl location) {
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        ((IForgeRegistryEntry)object).setRegistryName(location);
        return GameData.register_impl(object);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object) {
        IForgeRegistryEntry castedObj = (IForgeRegistryEntry)object;
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        if (castedObj.getRegistryName() == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register object without having set a registry name {} (type {})", new Object[]{object, object.getClass().getName()});
            throw new IllegalArgumentException(String.format("No registry name set for object %s (%s)", object, object.getClass().getName()));
        }
        IForgeRegistry<IForgeRegistryEntry> registry = PersistentRegistryManager.findRegistry(castedObj);
        registry.register(castedObj);
        return (K)castedObj;
    }

    public static cv<ard> getBlockStateIDMap() {
        return GameData.getMain().iBlockRegistry.getSlaveMap(BLOCKSTATE_TO_ID, cv.class);
    }

    public static void vanillaSnapshot() {
        PersistentRegistryManager.freezeVanilla();
    }

    public <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class BiomeCallbacks
    implements IForgeRegistry.AddCallback<aig>,
    IForgeRegistry.ClearCallback<aig>,
    IForgeRegistry.CreateCallback<aig> {
        static final BiomeCallbacks INSTANCE = new BiomeCallbacks();

        private BiomeCallbacks() {
        }

        @Override
        public void onAdd(aig potion, int id, Map<kl, ?> slaves) {
        }

        @Override
        public void onClear(Map<kl, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kl, ?> slaveset) {
        }
    }

    private static class PotionCallbacks
    implements IForgeRegistry.AddCallback<rk>,
    IForgeRegistry.ClearCallback<rk>,
    IForgeRegistry.CreateCallback<rk> {
        static final PotionCallbacks INSTANCE = new PotionCallbacks();

        private PotionCallbacks() {
        }

        @Override
        public void onAdd(rk potion, int id, Map<kl, ?> slaves) {
        }

        @Override
        public void onClear(Map<kl, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kl, ?> slaveset) {
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<ado>,
    IForgeRegistry.ClearCallback<ado>,
    IForgeRegistry.CreateCallback<ado> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(ado item, int blockId, Map<kl, ?> slaves) {
            if (item instanceof acc) {
                acc itemBlock = (acc)item;
                BiMap blockToItem = (BiMap)slaves.get(BLOCK_TO_ITEM);
                blockToItem.forcePut(itemBlock.d().delegate.get(), (Object)item);
            }
        }

        @Override
        public void onClear(Map<kl, ?> slaveset) {
            Map map = (Map)slaveset.get(BLOCK_TO_ITEM);
            map.clear();
        }

        @Override
        public void onCreate(Map<kl, ?> slaveset) {
            HashBiMap map = HashBiMap.create();
            slaveset.put(BLOCK_TO_ITEM, map);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<ajt>,
    IForgeRegistry.ClearCallback<ajt>,
    IForgeRegistry.CreateCallback<ajt> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(ajt block, int blockId, Map<kl, ?> slaves) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaves.get(BLOCKSTATE_TO_ID));
            for (ard state : block.t().a()) {
                blockstateMap.a(state, blockId << 4 | block.e(state));
            }
        }

        @Override
        public void onClear(Map<kl, ?> slaveset) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaveset.get(BLOCKSTATE_TO_ID));
            blockstateMap.clear();
        }

        @Override
        public void onCreate(Map<kl, ?> slaveset) {
            ClearableObjectIntIdentityMap idMap = new ClearableObjectIntIdentityMap();
            slaveset.put(BLOCKSTATE_TO_ID, idMap);
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends cv<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

