/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public final class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @Subscribe
    public void modPreinitialization(FMLPreInitializationEvent evt) {
        if (ForgeRegistries.ITEMS == null) {
            throw new RuntimeException("Something horrible went wrong in init, ForgeRegistres didn't create...");
        }
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public dq getDataForWriting(azf handler, azh info) {
        dq fmlData = new dq();
        dw modList = new dw();
        for (ModContainer mc2 : Loader.instance().getActiveModList()) {
            dq mod = new dq();
            mod.a("ModId", mc2.getModId());
            mod.a("ModVersion", mc2.getVersion());
            modList.a((ed)mod);
        }
        fmlData.a("ModList", (ed)modList);
        dq registries = new dq();
        fmlData.a("Registries", (ed)registries);
        FMLLog.fine("Gathering id map for writing to world save %s", info.j());
        PersistentRegistryManager.GameDataSnapshot dataSnapshot = PersistentRegistryManager.takeSnapshot();
        for (Map.Entry<kl, PersistentRegistryManager.GameDataSnapshot.Entry> e : dataSnapshot.entries.entrySet()) {
            Object entry3;
            dq data = new dq();
            registries.a(e.getKey().toString(), (ed)data);
            dw ids = new dw();
            for (Map.Entry<kl, Integer> entry2 : e.getValue().ids.entrySet()) {
                dq tag = new dq();
                tag.a("K", entry2.getKey().toString());
                tag.a("V", entry2.getValue().intValue());
                ids.a((ed)tag);
            }
            data.a("ids", (ed)ids);
            dw aliases = new dw();
            for (Object entry3 : e.getValue().aliases.entrySet()) {
                dq tag = new dq();
                tag.a("K", entry3.getKey().toString());
                tag.a("V", ((kl)entry3.getValue()).toString());
                aliases.a((ed)tag);
            }
            data.a("aliases", (ed)aliases);
            dw dw2 = new dw();
            entry3 = e.getValue().substitutions.iterator();
            while (entry3.hasNext()) {
                kl entry4 = (kl)entry3.next();
                dq tag = new dq();
                tag.a("K", entry4.toString());
                dw2.a((ed)tag);
            }
            data.a("substitutions", (ed)dw2);
            int[] blocked = new int[e.getValue().blocked.size()];
            int idx = 0;
            for (Integer i : e.getValue().blocked) {
                blocked[idx++] = i;
            }
            data.a("blocked", blocked);
            dw dummied = new dw();
            for (kl entry5 : e.getValue().dummied) {
                dq tag = new dq();
                tag.a("K", entry5.toString());
                dummied.a((ed)tag);
            }
            data.a("dummied", (ed)dummied);
        }
        return fmlData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readData(azf handler, azh info, Map<String, ed> propertyMap, dq tag) {
        if (tag.e("ModList")) {
            dw modList = tag.c("ModList", 10);
            for (int i = 0; i < modList.c(); ++i) {
                dq mod = modList.b(i);
                String modId = mod.l("ModId");
                String modVersion = mod.l("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        List<String> failedElements = null;
        if (tag.e("ModItemData")) {
            StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
            StartupQuery.abort();
        } else if (tag.e("ItemData")) {
            void var11_22;
            void var11_18;
            if (!tag.e("BlockedItemIds")) {
                StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
                StartupQuery.abort();
            }
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            PersistentRegistryManager.GameDataSnapshot.Entry blocks = new PersistentRegistryManager.GameDataSnapshot.Entry();
            PersistentRegistryManager.GameDataSnapshot.Entry items = new PersistentRegistryManager.GameDataSnapshot.Entry();
            snapshot.entries.put(PersistentRegistryManager.BLOCKS, blocks);
            snapshot.entries.put(PersistentRegistryManager.ITEMS, items);
            dw list = tag.c("ItemData", 10);
            for (int i2 = 0; i2 < list.c(); ++i2) {
                dq dq2 = list.b(i2);
                String name = dq2.l("K");
                if (name.charAt(0) == '\u0001') {
                    blocks.ids.put(new kl(name.substring(1)), dq2.h("V"));
                    continue;
                }
                if (name.charAt(0) != '\u0002') continue;
                items.ids.put(new kl(name.substring(1)), dq2.h("V"));
            }
            HashSet<Integer> blockedIds = new HashSet<Integer>();
            for (int id : tag.n("BlockedItemIds")) {
                blockedIds.add(id);
            }
            blocks.blocked.addAll(blockedIds);
            items.blocked.addAll(blockedIds);
            list = tag.c("BlockAliases", 10);
            boolean bl = false;
            while (var11_18 < list.c()) {
                dq dataTag = list.b((int)var11_18);
                blocks.aliases.put(new kl(dataTag.l("K")), new kl(dataTag.l("V")));
                ++var11_18;
            }
            if (tag.b("BlockSubstitutions", 9)) {
                void var11_20;
                list = tag.c("BlockSubstitutions", 10);
                boolean bl2 = false;
                while (var11_20 < list.c()) {
                    dq dataTag = list.b((int)var11_20);
                    blocks.substitutions.add(new kl(dataTag.l("K")));
                    ++var11_20;
                }
            }
            list = tag.c("ItemAliases", 10);
            boolean bl3 = false;
            while (var11_22 < list.c()) {
                dq dataTag = list.b((int)var11_22);
                items.aliases.put(new kl(dataTag.l("K")), new kl(dataTag.l("V")));
                ++var11_22;
            }
            if (tag.b("ItemSubstitutions", 9)) {
                void var11_24;
                list = tag.c("ItemSubstitutions", 10);
                boolean bl4 = false;
                while (var11_24 < list.c()) {
                    dq dataTag = list.b((int)var11_24);
                    items.substitutions.add(new kl(dataTag.l("K")));
                    ++var11_24;
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        } else if (tag.e("Registries")) {
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            dq regs = tag.o("Registries");
            for (String key : regs.c()) {
                int[] blocked;
                int x;
                void var11_25;
                PersistentRegistryManager.GameDataSnapshot.Entry entry = new PersistentRegistryManager.GameDataSnapshot.Entry();
                if ("fml:blocks".equals(key)) {
                    kl kl2 = PersistentRegistryManager.BLOCKS;
                } else if ("fml:items".equals(key)) {
                    kl kl3 = PersistentRegistryManager.ITEMS;
                } else if ("fmlgr:villagerprofessions".equals(key)) {
                    kl kl4 = VillagerRegistry.PROFESSIONS;
                } else {
                    kl kl5 = new kl(key);
                }
                snapshot.entries.put((kl)var11_25, entry);
                dw list = regs.o(key).c("ids", 10);
                for (x = 0; x < list.c(); ++x) {
                    dq e3 = list.b(x);
                    entry.ids.put(new kl(e3.l("K")), e3.h("V"));
                }
                list = regs.o(key).c("aliases", 10);
                for (x = 0; x < list.c(); ++x) {
                    dq e4 = list.b(x);
                    entry.aliases.put(new kl(e4.l("K")), new kl(e4.l("V")));
                }
                list = regs.o(key).c("substitutions", 10);
                for (x = 0; x < list.c(); ++x) {
                    dq e5 = list.b(x);
                    entry.substitutions.add(new kl(e5.l("K")));
                }
                for (int i : blocked = regs.o(key).n("blocked")) {
                    entry.blocked.add(i);
                }
                if (!regs.o(key).e("dummied")) continue;
                list = regs.o(key).c("dummied", 10);
                for (int x2 = 0; x2 < list.c(); ++x2) {
                    dq e6 = list.b(x2);
                    entry.dummied.add(new kl(e6.l("K")));
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            String text = "Forge Mod Loader could not load this save.\n\nThere are " + failedElements.size() + " unassigned blocks and items in this save.\n" + "You will not be able to load until they are present again.\n\n" + "Missing Blocks/Items:\n";
            for (String s : failedElements) {
                text = text + s + "\n";
            }
            StartupQuery.notify(text);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "net.minecraftforge.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

