/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBlockWrapper
implements IFluidHandler {
    protected final IFluidBlock fluidBlock;
    protected final aht world;
    protected final cl blockPos;

    public FluidBlockWrapper(IFluidBlock fluidBlock, aht world, cl blockPos) {
        this.fluidBlock = fluidBlock;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        int amountFilled;
        float percentFilled = this.fluidBlock.getFilledPercentage(this.world, this.blockPos);
        if (percentFilled < 0.0f) {
            percentFilled *= -1.0f;
        }
        FluidStack fluid = (amountFilled = Math.round(1000.0f * percentFilled)) > 0 ? new FluidStack(this.fluidBlock.getFluid(), amountFilled) : null;
        return new FluidTankProperties[]{new FluidTankProperties(fluid, 1000, false, true)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !this.fluidBlock.canDrain(this.world, this.blockPos)) {
            return null;
        }
        FluidStack simulatedDrain = this.fluidBlock.drain(this.world, this.blockPos, false);
        if (resource.containsFluid(simulatedDrain)) {
            if (doDrain) {
                return this.fluidBlock.drain(this.world, this.blockPos, true);
            }
            return simulatedDrain;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0 || !this.fluidBlock.canDrain(this.world, this.blockPos)) {
            return null;
        }
        FluidStack simulatedDrain = this.fluidBlock.drain(this.world, this.blockPos, false);
        if (simulatedDrain != null && simulatedDrain.amount <= maxDrain) {
            if (doDrain) {
                return this.fluidBlock.drain(this.world, this.blockPos, true);
            }
            return simulatedDrain;
        }
        return null;
    }
}

