/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BlockLiquidWrapper
implements IFluidHandler {
    protected final amo blockLiquid;
    protected final aht world;
    protected final cl blockPos;

    public BlockLiquidWrapper(amo blockLiquid, aht world, cl blockPos) {
        this.blockLiquid = blockLiquid;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        FluidStack containedStack = null;
        ard blockState = this.world.o(this.blockPos);
        if (blockState.t() == this.blockLiquid) {
            containedStack = this.getStack(blockState);
        }
        return new FluidTankProperties[]{new FluidTankProperties(containedStack, 1000, false, true)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack containedStack;
        if (resource == null || resource.amount < 1000) {
            return null;
        }
        ard blockState = this.world.o(this.blockPos);
        if (blockState.t() == this.blockLiquid && (Integer)blockState.c((ars)amo.b) == 0 && (containedStack = this.getStack(blockState)) != null && resource.containsFluid(containedStack)) {
            if (doDrain) {
                this.world.a(this.blockPos, aju.a.u(), 11);
            }
            return containedStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack containedStack;
        if (maxDrain < 1000) {
            return null;
        }
        ard blockState = this.world.o(this.blockPos);
        if (blockState.t() == this.blockLiquid && (containedStack = this.getStack(blockState)) != null && containedStack.amount <= maxDrain) {
            if (doDrain) {
                this.world.a(this.blockPos, aju.a.u(), 11);
            }
            return containedStack;
        }
        return null;
    }

    @Nullable
    private FluidStack getStack(ard blockState) {
        axe material = blockState.a();
        if (material == axe.h && (Integer)blockState.c((ars)amo.b) == 0) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (material == axe.i && (Integer)blockState.c((ars)amo.b) == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }
}

