/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.terraingen;

import java.util.Random;
import net.minecraftforge.event.world.WorldEvent;

public class InitNoiseGensEvent<T extends Context>
extends WorldEvent {
    private final Random rand;
    private final T original;
    private T newValues;

    public InitNoiseGensEvent(aht world, Random rand, T original) {
        super(world);
        this.rand = rand;
        this.original = original;
        this.newValues = ((Context)original).clone();
    }

    public Random getRandom() {
        return this.rand;
    }

    public T getOriginal() {
        return this.original;
    }

    public T getNewValues() {
        return this.newValues;
    }

    public static class ContextHell
    extends Context {
        private awu perlin2;
        private awu perlin3;

        public ContextHell(awu lperlin1, awu lperlin2, awu perlin, awu perlin2, awu perlin3, awu scale, awu depth) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.perlin2 = perlin2;
            this.perlin3 = perlin3;
        }

        @Override
        public ContextHell clone() {
            return new ContextHell(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.perlin2, this.perlin3, this.getScale(), this.getDepth());
        }

        public awu getPerlin2() {
            return this.perlin2;
        }

        public awu getPerlin3() {
            return this.perlin3;
        }

        public void getPerlin2(awu value) {
            this.perlin2 = value;
        }

        public void getPerlin3(awu value) {
            this.perlin3 = value;
        }
    }

    public static class ContextEnd
    extends Context {
        private awy island;

        public ContextEnd(awu lperlin1, awu lperlin2, awu perlin, awu scale, awu depth, awy island) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.island = island;
        }

        @Override
        public ContextEnd clone() {
            return new ContextEnd(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.getScale(), this.getDepth(), this.island);
        }

        public awy getIsland() {
            return this.island;
        }

        public void getIsland(awy value) {
            this.island = value;
        }
    }

    public static class ContextOverworld
    extends Context {
        private awv height;
        private awu forest;

        public ContextOverworld(awu lperlin1, awu lperlin2, awu perlin, awv height, awu scale, awu depth, awu forest) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.height = height;
            this.forest = forest;
        }

        @Override
        public ContextOverworld clone() {
            return new ContextOverworld(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.height, this.getScale(), this.getDepth(), this.forest);
        }

        public awv getHeight() {
            return this.height;
        }

        public awu getForest() {
            return this.forest;
        }

        public void getHeight(awv value) {
            this.height = value;
        }

        public void getForest(awu value) {
            this.forest = value;
        }
    }

    public static class Context {
        private awu lperlin1;
        private awu lperlin2;
        private awu perlin;
        private awu scale;
        private awu depth;

        public Context(awu lperlin1, awu lperlin2, awu perlin, awu scale, awu depth) {
            this.lperlin1 = lperlin1;
            this.lperlin2 = lperlin2;
            this.perlin = perlin;
            this.scale = scale;
            this.depth = depth;
        }

        public awu getLPerlin1() {
            return this.lperlin1;
        }

        public awu getLPerlin2() {
            return this.lperlin2;
        }

        public awu getPerlin() {
            return this.perlin;
        }

        public awu getScale() {
            return this.scale;
        }

        public awu getDepth() {
            return this.depth;
        }

        public void setLPerlin1(awu value) {
            this.lperlin1 = value;
        }

        public void getLPerlin2(awu value) {
            this.lperlin2 = value;
        }

        public void getPerlin(awu value) {
            this.perlin = value;
        }

        public void getScale(awu value) {
            this.scale = value;
        }

        public void getDepth(awu value) {
            this.depth = value;
        }

        public Context clone() {
            return new Context(this.lperlin1, this.lperlin2, this.perlin, this.scale, this.depth);
        }
    }
}

