/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public interface IPerspectiveAwareModel
extends bxl {
    public Pair<? extends bxl, Matrix4f> handlePerspective(bop.b var1);

    public static class MapWrapper
    implements IPerspectiveAwareModel {
        private final bxl parent;
        private final ImmutableMap<bop.b, TRSRTransformation> transforms;

        public MapWrapper(bxl parent, ImmutableMap<bop.b, TRSRTransformation> transforms) {
            this.parent = parent;
            this.transforms = transforms;
        }

        public MapWrapper(bxl parent, IModelState state) {
            this(parent, MapWrapper.getTransforms(state));
        }

        public static ImmutableMap<bop.b, TRSRTransformation> getTransforms(IModelState state) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bop.b type : bop.b.values()) {
                Optional<TRSRTransformation> tr = state.apply((Optional<? extends IModelPart>)Optional.of((Object)type));
                if (!tr.isPresent()) continue;
                builder.put((Object)type, tr.get());
            }
            return builder.build();
        }

        public static ImmutableMap<bop.b, TRSRTransformation> getTransforms(bop transforms) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bop.b type : bop.b.values()) {
                builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner(new TRSRTransformation(transforms.b(type))));
            }
            return builder.build();
        }

        public static Pair<? extends bxl, Matrix4f> handlePerspective(bxl model, ImmutableMap<bop.b, TRSRTransformation> transforms, bop.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)transforms.get((Object)cameraTransformType);
            Matrix4f mat = null;
            if (tr != null && !tr.equals(TRSRTransformation.identity())) {
                mat = TRSRTransformation.blockCornerToCenter(tr).getMatrix();
            }
            return Pair.of((Object)model, mat);
        }

        public static Pair<? extends bxl, Matrix4f> handlePerspective(bxl model, IModelState state, bop.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.of((Object)cameraTransformType)).or((Object)TRSRTransformation.identity());
            if (tr != TRSRTransformation.identity()) {
                return Pair.of((Object)model, (Object)TRSRTransformation.blockCornerToCenter(tr).getMatrix());
            }
            return Pair.of((Object)model, null);
        }

        public boolean a() {
            return this.parent.a();
        }

        public boolean b() {
            return this.parent.b();
        }

        public boolean c() {
            return this.parent.c();
        }

        public bve d() {
            return this.parent.d();
        }

        public bop e() {
            return this.parent.e();
        }

        public List<boc> a(ard state, cs side, long rand) {
            return this.parent.a(state, side, rand);
        }

        public bon f() {
            return this.parent.f();
        }

        @Override
        public Pair<? extends bxl, Matrix4f> handlePerspective(bop.b cameraTransformType) {
            return MapWrapper.handlePerspective((bxl)this, this.transforms, cameraTransformType);
        }
    }
}

