/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.util.CheckClassAdapter;
import org.spongepowered.asm.lib.util.TraceClassVisitor;

public class ASMHelper {
    public static final int[] CONSTANTS_INT = new int[]{2, 3, 4, 5, 6, 7, 8};
    public static final int[] CONSTANTS_FLOAT = new int[]{11, 12, 13};
    public static final int[] CONSTANTS_DOUBLE = new int[]{14, 15};
    public static final int[] CONSTANTS_LONG = new int[]{9, 10};
    public static final int[] CONSTANTS_ALL = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    private static final Object[] CONSTANTS_VALUES = new Object[]{null, -1, 0, 1, 2, 3, 4, 5, 0L, 1L, Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), 0.0, 1.0};
    private static final String[] CONSTANTS_TYPES = new String[]{null, "I", "I", "I", "I", "I", "I", "I", "J", "J", "F", "F", "F", "D", "D", "I", "I"};

    public static void generateBooleanMethodConst(ClassNode clazz, String name, boolean retval) {
        MethodNode method = new MethodNode(327680, 4097, name, "()Z", null, null);
        InsnList code = method.instructions;
        code.add(ASMHelper.pushIntConstant(retval ? 1 : 0));
        code.add(new InsnNode(172));
        clazz.methods.add(method);
    }

    public static void generateIntegerMethodConst(ClassNode clazz, String name, short retval) {
        MethodNode method = new MethodNode(327680, 4097, name, "()I", null, null);
        InsnList code = method.instructions;
        code.add(ASMHelper.pushIntConstant(retval));
        code.add(new InsnNode(172));
        clazz.methods.add(method);
    }

    public static void generateSelfForwardingMethod(ClassNode clazz, String name, String forwardname, Type rettype) {
        MethodNode method = new MethodNode(327680, 4097, name, "()" + rettype.getDescriptor(), null, null);
        ASMHelper.populateSelfForwardingMethod(method, forwardname, rettype, Type.getObjectType(clazz.name));
        clazz.methods.add(method);
    }

    public static void generateStaticForwardingMethod(ClassNode clazz, String name, String forwardname, Type rettype, Type argtype) {
        MethodNode method = new MethodNode(327680, 4105, name, "()" + rettype.getDescriptor(), null, null);
        ASMHelper.populateSelfForwardingMethod(method, forwardname, rettype, argtype);
        clazz.methods.add(method);
    }

    public static void generateForwardingToStaticMethod(ClassNode clazz, String name, String forwardname, Type rettype, Type fowardtype) {
        MethodNode method = new MethodNode(327680, 4097, name, "()" + rettype.getDescriptor(), null, null);
        ASMHelper.populateForwardingToStaticMethod(method, forwardname, rettype, Type.getObjectType(clazz.name), fowardtype);
        clazz.methods.add(method);
    }

    public static void generateForwardingToStaticMethod(ClassNode clazz, String name, String forwardname, Type rettype, Type fowardtype, Type thistype) {
        MethodNode method = new MethodNode(327680, 4097, name, "()" + rettype.getDescriptor(), null, null);
        ASMHelper.populateForwardingToStaticMethod(method, forwardname, rettype, thistype, fowardtype);
        clazz.methods.add(method);
    }

    public static void replaceSelfForwardingMethod(MethodNode method, String forwardname, Type thistype) {
        Type methodType = Type.getMethodType(method.desc);
        method.instructions.clear();
        ASMHelper.populateSelfForwardingMethod(method, forwardname, methodType.getReturnType(), thistype);
    }

    public static void generateForwardingMethod(ClassNode clazz, String name, String forwardname, Type rettype, Type argtype) {
        MethodNode method = new MethodNode(327680, 4097, name, "()" + rettype.getDescriptor(), null, null);
        ASMHelper.populateForwardingMethod(method, forwardname, rettype, argtype, Type.getObjectType(clazz.name));
        clazz.methods.add(method);
    }

    public static void replaceForwardingMethod(MethodNode method, String forwardname, Type thistype) {
        Type methodType = Type.getMethodType(method.desc);
        method.instructions.clear();
        ASMHelper.populateForwardingMethod(method, forwardname, methodType.getReturnType(), methodType.getArgumentTypes()[0], thistype);
    }

    public static void populateForwardingToStaticMethod(MethodNode method, String forwardname, Type rettype, Type thistype, Type forwardtype) {
        InsnList code = method.instructions;
        code.add(new VarInsnNode(thistype.getOpcode(21), 0));
        code.add(new MethodInsnNode(184, forwardtype.getInternalName(), forwardname, Type.getMethodDescriptor(rettype, thistype), false));
        code.add(new InsnNode(rettype.getOpcode(172)));
    }

    public static void populateSelfForwardingMethod(MethodNode method, String forwardname, Type rettype, Type thistype) {
        InsnList code = method.instructions;
        code.add(new VarInsnNode(thistype.getOpcode(21), 0));
        code.add(new MethodInsnNode(182, thistype.getInternalName(), forwardname, "()" + rettype.getDescriptor(), false));
        code.add(new InsnNode(rettype.getOpcode(172)));
    }

    public static void populateForwardingMethod(MethodNode method, String forwardname, Type rettype, Type argtype, Type thistype) {
        InsnList code = method.instructions;
        code.add(new VarInsnNode(argtype.getOpcode(21), 1));
        code.add(new MethodInsnNode(182, argtype.getInternalName(), forwardname, "()" + rettype.getDescriptor(), false));
        code.add(new InsnNode(rettype.getOpcode(172)));
    }

    public static AbstractInsnNode pushIntConstant(int c2) {
        if (c2 == -1) {
            return new InsnNode(2);
        }
        if (c2 >= 0 && c2 <= 5) {
            return new InsnNode(CONSTANTS_INT[c2 + 1]);
        }
        if (c2 >= -128 && c2 <= 127) {
            return new IntInsnNode(16, c2);
        }
        if (c2 >= Short.MIN_VALUE && c2 <= Short.MAX_VALUE) {
            return new IntInsnNode(17, c2);
        }
        return new LdcInsnNode((Object)c2);
    }

    public static MethodNode findMethod(ClassNode clazz, String name, String desc) {
        for (MethodNode m2 : clazz.methods) {
            if (!m2.name.equals(name) || !m2.desc.equals(desc)) continue;
            return m2;
        }
        return null;
    }

    public static void addAndReplaceMethod(ClassNode clazz, MethodNode method) {
        MethodNode m2 = ASMHelper.findMethod(clazz, method.name, method.desc);
        if (m2 != null) {
            clazz.methods.remove(m2);
        }
        clazz.methods.add(method);
    }

    public static void textify(ClassNode classNode, OutputStream out) {
        classNode.accept(new TraceClassVisitor(new PrintWriter(out)));
    }

    public static void textify(MethodNode methodNode, OutputStream out) {
        TraceClassVisitor trace = new TraceClassVisitor(new PrintWriter(out));
        MethodVisitor mv = trace.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
        methodNode.accept(mv);
        trace.visitEnd();
    }

    public static void dumpClass(ClassNode classNode) {
        ClassWriter cw = new ClassWriter(3);
        classNode.accept(cw);
        ASMHelper.dumpClass(cw.toByteArray());
    }

    public static void dumpClass(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        CheckClassAdapter.verify(cr, true, new PrintWriter(System.out));
    }

    public static void printMethodWithOpcodeIndices(MethodNode method) {
        System.err.printf("%s%s\n", method.name, method.desc);
        int i2 = 0;
        ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
        while (iter.hasNext()) {
            System.err.printf("[%4d] %s\n", i2++, ASMHelper.getNodeDescriptionForDebug((AbstractInsnNode)iter.next()));
        }
    }

    public static void printMethod(MethodNode method) {
        System.err.printf("%s%s\n", method.name, method.desc);
        ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
        while (iter.hasNext()) {
            System.err.print("  ");
            ASMHelper.printNode((AbstractInsnNode)iter.next());
        }
    }

    public static void printNode(AbstractInsnNode node) {
        System.err.printf("%s\n", ASMHelper.getNodeDescriptionForDebug(node));
    }

    public static String getNodeDescriptionForDebug(AbstractInsnNode node) {
        String out = String.format("%-14s ", node.getClass().getSimpleName().replace("Node", ""));
        if (node instanceof LabelNode) {
            out = out + String.format("[%s]", ((LabelNode)node).getLabel());
        } else if (node instanceof JumpInsnNode) {
            out = out + String.format("[%s] [%s]", ASMHelper.getOpcodeName(node), ((JumpInsnNode)node).label.getLabel());
        } else if (node instanceof VarInsnNode) {
            out = out + String.format("[%s] %d", ASMHelper.getOpcodeName(node), ((VarInsnNode)node).var);
        } else if (node instanceof MethodInsnNode) {
            MethodInsnNode mth = (MethodInsnNode)node;
            out = out + String.format("[%s] %s %s %s", ASMHelper.getOpcodeName(node), mth.owner, mth.name, mth.desc);
        } else if (node instanceof FieldInsnNode) {
            FieldInsnNode fld = (FieldInsnNode)node;
            out = out + String.format("[%s] %s %s %s", ASMHelper.getOpcodeName(node), fld.owner, fld.name, fld.desc);
        } else if (node instanceof LineNumberNode) {
            LineNumberNode ln = (LineNumberNode)node;
            out = out + String.format("LINE=%d LABEL=[%s]", ln.line, ln.start.getLabel());
        } else {
            out = node instanceof LdcInsnNode ? out + ((LdcInsnNode)node).cst : (node instanceof IntInsnNode ? out + ((IntInsnNode)node).operand : out + String.format("[%s] ", ASMHelper.getOpcodeName(node)));
        }
        return out;
    }

    public static String getOpcodeName(AbstractInsnNode node) {
        return ASMHelper.getOpcodeName(node.getOpcode());
    }

    public static String getOpcodeName(int opcode) {
        if (opcode > 0) {
            boolean found = false;
            try {
                for (Field f : Opcodes.class.getDeclaredFields()) {
                    if (!found && f.getName() != "UNINITIALIZED_THIS") continue;
                    found = true;
                    if (f.getType() != Integer.TYPE || f.getInt(null) != opcode) continue;
                    return f.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return opcode >= 0 ? String.valueOf(opcode) : "";
    }

    public static void setVisibleAnnotation(FieldNode field, Class<? extends Annotation> annotationClass, Object ... value) {
        AnnotationNode node = ASMHelper.makeAnnotationNode(Type.getDescriptor(annotationClass), value);
        field.visibleAnnotations = ASMHelper.addAnnotation(field.visibleAnnotations, node);
    }

    public static void setInvisibleAnnotation(FieldNode field, Class<? extends Annotation> annotationClass, Object ... value) {
        AnnotationNode node = ASMHelper.makeAnnotationNode(Type.getDescriptor(annotationClass), value);
        field.invisibleAnnotations = ASMHelper.addAnnotation(field.invisibleAnnotations, node);
    }

    public static void setVisibleAnnotation(MethodNode method, Class<? extends Annotation> annotationClass, Object ... value) {
        AnnotationNode node = ASMHelper.makeAnnotationNode(Type.getDescriptor(annotationClass), value);
        method.visibleAnnotations = ASMHelper.addAnnotation(method.visibleAnnotations, node);
    }

    public static void setInvisibleAnnotation(MethodNode method, Class<? extends Annotation> annotationClass, Object ... value) {
        AnnotationNode node = ASMHelper.makeAnnotationNode(Type.getDescriptor(annotationClass), value);
        method.invisibleAnnotations = ASMHelper.addAnnotation(method.invisibleAnnotations, node);
    }

    private static AnnotationNode makeAnnotationNode(String annotationType, Object ... value) {
        AnnotationNode node = new AnnotationNode(annotationType);
        for (int pos = 0; pos < value.length - 1; pos += 2) {
            if (!(value[pos] instanceof String)) {
                throw new IllegalArgumentException("Annotation keys must be strings, found " + value[pos].getClass().getSimpleName() + " with " + value[pos].toString() + " at index " + pos + " creating " + annotationType);
            }
            node.visit((String)value[pos], value[pos + 1]);
        }
        return node;
    }

    private static List<AnnotationNode> addAnnotation(List<AnnotationNode> annotations, AnnotationNode node) {
        if (annotations == null) {
            annotations = new ArrayList<AnnotationNode>(1);
        } else {
            annotations.remove(ASMHelper.getAnnotation(annotations, node.desc));
        }
        annotations.add(node);
        return annotations;
    }

    public static AnnotationNode getVisibleAnnotation(FieldNode field, Class<? extends Annotation> annotationClass) {
        return ASMHelper.getAnnotation(field.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getInvisibleAnnotation(FieldNode field, Class<? extends Annotation> annotationClass) {
        return ASMHelper.getAnnotation(field.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getVisibleAnnotation(MethodNode method, Class<? extends Annotation> annotationClass) {
        return ASMHelper.getAnnotation(method.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getInvisibleAnnotation(MethodNode method, Class<? extends Annotation> annotationClass) {
        return ASMHelper.getAnnotation(method.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getSingleVisibleAnnotation(MethodNode method, Class<? extends Annotation> ... annotationClasses) {
        return ASMHelper.getSingleAnnotation(method.visibleAnnotations, annotationClasses);
    }

    public static AnnotationNode getSingleInvisibleAnnotation(MethodNode method, Class<? extends Annotation> ... annotationClasses) {
        return ASMHelper.getSingleAnnotation(method.invisibleAnnotations, annotationClasses);
    }

    public static AnnotationNode getVisibleAnnotation(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return ASMHelper.getAnnotation(classNode.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getInvisibleAnnotation(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return ASMHelper.getAnnotation(classNode.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    public static AnnotationNode getVisibleParameterAnnotation(MethodNode method, Class<? extends Annotation> annotationClass, int paramIndex) {
        return ASMHelper.getParameterAnnotation(method.visibleParameterAnnotations, Type.getDescriptor(annotationClass), paramIndex);
    }

    public static AnnotationNode getInvisibleParameterAnnotation(MethodNode method, Class<? extends Annotation> annotationClass, int paramIndex) {
        return ASMHelper.getParameterAnnotation(method.invisibleParameterAnnotations, Type.getDescriptor(annotationClass), paramIndex);
    }

    public static AnnotationNode getParameterAnnotation(List<AnnotationNode>[] parameterAnnotations, String annotationType, int paramIndex) {
        if (parameterAnnotations == null || paramIndex < 0 || paramIndex >= parameterAnnotations.length) {
            return null;
        }
        return ASMHelper.getAnnotation(parameterAnnotations[paramIndex], annotationType);
    }

    public static AnnotationNode getAnnotation(List<AnnotationNode> annotations, String annotationType) {
        if (annotations == null) {
            return null;
        }
        for (AnnotationNode annotation : annotations) {
            if (!annotationType.equals(annotation.desc)) continue;
            return annotation;
        }
        return null;
    }

    private static AnnotationNode getSingleAnnotation(List<AnnotationNode> annotations, Class<? extends Annotation> ... annotationClasses) {
        ArrayList<AnnotationNode> nodes = new ArrayList<AnnotationNode>();
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            AnnotationNode annotation = ASMHelper.getAnnotation(annotations, Type.getDescriptor(annotationClass));
            if (annotation == null) continue;
            nodes.add(annotation);
        }
        int foundNodes = nodes.size();
        if (foundNodes > 1) {
            throw new IllegalArgumentException("Conflicting annotations found: " + annotationClasses);
        }
        return foundNodes == 0 ? null : (AnnotationNode)nodes.get(0);
    }

    public static <T> T getAnnotationValue(AnnotationNode annotation) {
        return ASMHelper.getAnnotationValue(annotation, "value");
    }

    public static <T> T getAnnotationValue(AnnotationNode annotation, String key, T defaultValue) {
        T returnValue = ASMHelper.getAnnotationValue(annotation, key);
        return returnValue != null ? returnValue : defaultValue;
    }

    public static <T> T getAnnotationValue(AnnotationNode annotation, String key, Class<?> annotationClass) {
        Preconditions.checkNotNull(annotationClass, (Object)"annotationClass cannot be null");
        Object value = ASMHelper.getAnnotationValue(annotation, key);
        if (value == null) {
            try {
                value = annotationClass.getDeclaredMethod(key, new Class[0]).getDefaultValue();
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return value;
    }

    public static <T> T getAnnotationValue(AnnotationNode annotation, String key) {
        boolean getNextValue = false;
        if (annotation == null || annotation.values == null) {
            return null;
        }
        for (Object value : annotation.values) {
            if (getNextValue) {
                return (T)value;
            }
            if (!value.equals(key)) continue;
            getNextValue = true;
        }
        return null;
    }

    public static <T extends Enum<T>> T getAnnotationValue(AnnotationNode annotationNode, String key, Class<T> enumClass, T defaultValue) {
        String[] value = (String[])ASMHelper.getAnnotationValue(annotationNode, key);
        if (value == null) {
            return defaultValue;
        }
        if (!enumClass.getName().equals(Type.getType(value[0]).getClassName())) {
            throw new IllegalArgumentException("The supplied enum class does not match the stored enum value");
        }
        return Enum.valueOf(enumClass, value[1]);
    }

    public static boolean methodIsStatic(MethodNode method) {
        return (method.access & 8) == 8;
    }

    public static boolean fieldIsStatic(FieldNode field) {
        return (field.access & 8) == 8;
    }

    public static int getFirstNonArgLocalIndex(MethodNode method) {
        return ASMHelper.getFirstNonArgLocalIndex(Type.getArgumentTypes(method.desc), (method.access & 8) == 0);
    }

    public static int getFirstNonArgLocalIndex(Type[] args, boolean includeThis) {
        return ASMHelper.getArgsSize(args) + (includeThis ? 1 : 0);
    }

    public static int getArgsSize(Type[] args) {
        int size = 0;
        for (Type type : args) {
            size += type.getSize();
        }
        return size;
    }

    public static void loadArgs(Type[] args, InsnList insns, int pos) {
        ASMHelper.loadArgs(args, insns, pos, -1);
    }

    public static void loadArgs(Type[] args, InsnList insns, int start, int end) {
        int pos = start;
        for (Type type : args) {
            insns.add(new VarInsnNode(type.getOpcode(21), pos));
            if (end < start || (pos += type.getSize()) < end) continue;
            return;
        }
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList source) {
        HashMap<LabelNode, LabelNode> labels = new HashMap<LabelNode, LabelNode>();
        ListIterator<AbstractInsnNode> iter = source.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (!(insn instanceof LabelNode)) continue;
            labels.put((LabelNode)insn, new LabelNode(((LabelNode)insn).getLabel()));
        }
        return labels;
    }

    public static String generateDescriptor(Object returnType, Object ... args) {
        StringBuilder sb = new StringBuilder().append('(');
        for (Object arg : args) {
            sb.append(ASMHelper.toDescriptor(arg));
        }
        return sb.append(')').append(returnType != null ? ASMHelper.toDescriptor(returnType) : "V").toString();
    }

    private static String toDescriptor(Object arg) {
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof Type) {
            return arg.toString();
        }
        if (arg instanceof Class) {
            return Type.getDescriptor((Class)arg).toString();
        }
        return arg == null ? "" : arg.toString();
    }

    public static String getSimpleName(AnnotationNode annotation) {
        return ASMHelper.getSimpleName(annotation.desc);
    }

    public static String getSimpleName(String desc) {
        return desc.substring(desc.lastIndexOf(47) + 1).replace(";", "");
    }

    public static boolean isConstant(AbstractInsnNode insn) {
        if (insn == null) {
            return false;
        }
        return Ints.contains((int[])CONSTANTS_ALL, (int)insn.getOpcode());
    }

    public static Object getConstant(AbstractInsnNode insn) {
        if (insn == null) {
            return null;
        }
        if (insn instanceof LdcInsnNode) {
            return ((LdcInsnNode)insn).cst;
        }
        if (insn instanceof IntInsnNode) {
            int value = ((IntInsnNode)insn).operand;
            if (insn.getOpcode() == 16 || insn.getOpcode() == 17) {
                return value;
            }
            throw new IllegalArgumentException("IntInsnNode with invalid opcode " + insn.getOpcode() + " in getConstant");
        }
        int index = Ints.indexOf((int[])CONSTANTS_ALL, (int)insn.getOpcode());
        return index < 0 ? null : CONSTANTS_VALUES[index];
    }

    public static Type getConstantType(AbstractInsnNode insn) {
        if (insn == null) {
            return null;
        }
        if (insn instanceof LdcInsnNode) {
            Object cst = ((LdcInsnNode)insn).cst;
            if (cst instanceof Integer) {
                return Type.getType("I");
            }
            if (cst instanceof Float) {
                return Type.getType("F");
            }
            if (cst instanceof Long) {
                return Type.getType("J");
            }
            if (cst instanceof Double) {
                return Type.getType("D");
            }
            if (cst instanceof String) {
                return Type.getType("Ljava/lang/String;");
            }
            if (cst instanceof Type) {
                return Type.getType("Ljava/lang/Class;");
            }
            throw new IllegalArgumentException("LdcInsnNode with invalid payload type " + cst.getClass() + " in getConstant");
        }
        int index = Ints.indexOf((int[])CONSTANTS_ALL, (int)insn.getOpcode());
        return index < 0 ? null : Type.getType(CONSTANTS_TYPES[index]);
    }
}

