/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;

public abstract class EntityUtilities {
    static final Predicate<rr> TRACEABLE = Predicates.and((Predicate)rv.e, (Predicate)new Predicate<rr>(){

        public boolean apply(rr entity) {
            return entity != null && entity.ap();
        }
    });

    public static bbg rayTraceFromEntity(rr source, double traceDistance, float partialTicks, boolean includeEntities) {
        bbg blockRay = EntityUtilities.rayTraceFromEntity(source, traceDistance, partialTicks);
        if (!includeEntities) {
            return blockRay;
        }
        bbh traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        double blockDistance = blockRay != null ? blockRay.c.f(traceStart) : traceDistance;
        EntityTrace entityRay = EntityUtilities.rayTraceEntities(source, traceDistance, partialTicks, blockDistance, traceStart);
        if (entityRay.entity != null && (entityRay.distance < blockDistance || blockRay == null)) {
            return entityRay.asRayTraceResult();
        }
        return blockRay;
    }

    private static EntityTrace rayTraceEntities(rr source, double traceDistance, float partialTicks, double blockDistance, bbh traceStart) {
        EntityTrace trace = new EntityTrace(blockDistance);
        bbh lookDir = source.f(partialTicks).a(traceDistance);
        bbh traceEnd = traceStart.e(lookDir);
        for (rr entity : EntityUtilities.getTraceEntities(source, traceDistance, lookDir, TRACEABLE)) {
            double distanceToEntity;
            bbf entityBB = entity.bm().g((double)entity.aA());
            bbg entityRay = entityBB.a(traceStart, traceEnd);
            if (entityBB.a(traceStart)) {
                if (!(trace.distance >= 0.0)) continue;
                trace.entity = entity;
                trace.location = entityRay == null ? traceStart : entityRay.c;
                trace.distance = 0.0;
                continue;
            }
            if (entityRay == null || !((distanceToEntity = traceStart.f(entityRay.c)) < trace.distance) && trace.distance != 0.0) continue;
            if (entity.bx() == source.bx()) {
                if (trace.distance != 0.0) continue;
                trace.entity = entity;
                trace.location = entityRay.c;
                continue;
            }
            trace.entity = entity;
            trace.location = entityRay.c;
            trace.distance = distanceToEntity;
        }
        return trace;
    }

    private static List<rr> getTraceEntities(rr source, double traceDistance, bbh dir, Predicate<rr> filter) {
        bbf boundingBox = source.bm();
        bbf traceBox = boundingBox.a(dir.b, dir.c, dir.d);
        List entities = source.l.a(source, traceBox.b(1.0, 1.0, 1.0), filter);
        return entities;
    }

    public static bbg rayTraceFromEntity(rr source, double traceDistance, float partialTicks) {
        bbh traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        bbh lookDir = source.f(partialTicks).a(traceDistance);
        bbh traceEnd = traceStart.e(lookDir);
        return source.l.a(traceStart, traceEnd, false, false, true);
    }

    public static bbh getPositionEyes(rr entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new bbh(entity.p, entity.q + (double)entity.bo(), entity.r);
        }
        double interpX = entity.m + (entity.p - entity.m) * (double)partialTicks;
        double interpY = entity.n + (entity.q - entity.n) * (double)partialTicks + (double)entity.bo();
        double interpZ = entity.o + (entity.r - entity.o) * (double)partialTicks;
        return new bbh(interpX, interpY, interpZ);
    }

    static final class EntityTrace {
        rr entity;
        bbh location;
        double distance;

        EntityTrace(double entityDistance) {
            this.distance = entityDistance;
        }

        bbg asRayTraceResult() {
            return new bbg(this.entity, this.location);
        }
    }
}

