/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.inject;

import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public class BeforeInvoke
extends InjectionPoint {
    protected final String[] methodNames;
    protected final String[] methodOwners;
    protected final String[] methodSignatures;
    protected final int ordinal;
    protected boolean logging = false;
    protected final String className;

    public BeforeInvoke(String ... methodNames) {
        this(methodNames, null, -1);
    }

    public BeforeInvoke(String methodName, int ordinal) {
        this(new String[]{methodName}, null, null, ordinal);
    }

    public BeforeInvoke(String[] methodNames, int ordinal) {
        this(methodNames, null, null, ordinal);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners) {
        this(methodNames, methodOwners, null, -1);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners, int ordinal) {
        this(methodNames, methodOwners, null, ordinal);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners, String[] methodSignatures) {
        this(methodNames, methodOwners, methodSignatures, -1);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners, String[] methodSignatures, int ordinal) {
        if (methodNames == null || methodNames.length == 0) {
            throw new IllegalArgumentException("Method name selector must not be null");
        }
        if (methodSignatures != null && methodSignatures.length == 0) {
            methodSignatures = null;
        }
        if (methodOwners != null && methodOwners.length == 0) {
            methodOwners = null;
        }
        if (ordinal < 0) {
            ordinal = -1;
        }
        this.methodNames = methodNames;
        this.methodOwners = methodOwners;
        this.methodSignatures = methodSignatures;
        this.ordinal = ordinal;
        this.className = this.getClass().getSimpleName();
        this.convertClassRefs();
    }

    public BeforeInvoke(MethodInfo method) {
        this(method, -1);
    }

    public BeforeInvoke(MethodInfo method, int ordinal) {
        this.methodNames = method.getNames();
        this.methodOwners = method.getOwners();
        this.methodSignatures = method.getDescriptors();
        this.ordinal = ordinal;
        this.className = this.getClass().getSimpleName();
        this.convertClassRefs();
    }

    private void convertClassRefs() {
        int i;
        for (i = 0; i < this.methodOwners.length; ++i) {
            if (this.methodOwners[i] == null) continue;
            this.methodOwners[i] = this.methodOwners[i].replace('.', '/');
        }
        if (this.methodSignatures != null) {
            for (i = 0; i < this.methodSignatures.length; ++i) {
                if (this.methodSignatures[i] == null) continue;
                this.methodSignatures[i] = this.methodSignatures[i].replace('.', '/');
            }
        }
    }

    public BeforeInvoke setLogging(boolean logging) {
        this.logging = logging;
        return this;
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes, Event event) {
        int ordinal = 0;
        boolean found = false;
        if (this.logging) {
            LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
            LiteLoaderLogger.debug(this.className + " is searching for an injection point in method with descriptor %s", desc);
        }
        for (AbstractInsnNode insn : insns) {
            if (this.matchesInsn(insn)) {
                int index;
                InsnInfo nodeInfo = new InsnInfo(insn);
                if (this.logging) {
                    LiteLoaderLogger.debug(this.className + " is considering insn NAME=%s DESC=%s OWNER=%s", nodeInfo.name, nodeInfo.desc, nodeInfo.owner);
                }
                if ((index = BeforeInvoke.arrayIndexOf(this.methodNames, nodeInfo.name, -1)) > -1 && this.logging) {
                    LiteLoaderLogger.debug(this.className + "   found a matching insn, checking owner/signature...", new Object[0]);
                }
                int ownerIndex = BeforeInvoke.arrayIndexOf(this.methodOwners, nodeInfo.owner, index);
                int descIndex = BeforeInvoke.arrayIndexOf(this.methodSignatures, nodeInfo.desc, index);
                if (index > -1 && ownerIndex == index && descIndex == index) {
                    if (this.logging) {
                        LiteLoaderLogger.debug(this.className + "     found a matching insn, checking preconditions...", new Object[0]);
                    }
                    if (this.matchesInsn(nodeInfo, ordinal)) {
                        if (this.logging) {
                            LiteLoaderLogger.debug(this.className + "         found a matching insn at ordinal %d", ordinal);
                        }
                        nodes.add(insn);
                        found = true;
                        if (this.ordinal == ordinal) break;
                    }
                    ++ordinal;
                }
            }
            this.inspectInsn(desc, insns, insn);
        }
        if (this.logging) {
            LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
        }
        return found;
    }

    protected boolean matchesInsn(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode;
    }

    protected void inspectInsn(String desc, InsnList insns, AbstractInsnNode insn) {
    }

    protected boolean matchesInsn(InsnInfo nodeInfo, int ordinal) {
        if (this.logging) {
            LiteLoaderLogger.debug(this.className + "       comparing target ordinal %d with current ordinal %d", this.ordinal, ordinal);
        }
        return this.ordinal == -1 || this.ordinal == ordinal;
    }

    private static int arrayIndexOf(String[] haystack, String needle, int pos) {
        if (haystack == null) {
            return pos;
        }
        if (pos > -1 && pos < haystack.length && needle.equals(haystack[pos])) {
            return pos;
        }
        for (int index = 0; index < haystack.length; ++index) {
            if (!needle.equals(haystack[index])) continue;
            return index;
        }
        return -1;
    }

    protected class InsnInfo {
        public final String owner;
        public final String name;
        public final String desc;

        public InsnInfo(AbstractInsnNode insn) {
            if (insn instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)insn;
                this.owner = methodNode.owner;
                this.name = methodNode.name;
                this.desc = methodNode.desc;
            } else if (insn instanceof FieldInsnNode) {
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                this.owner = fieldNode.owner;
                this.name = fieldNode.name;
                this.desc = fieldNode.desc;
            } else {
                throw new IllegalArgumentException("insn must be an instance of MethodInsnNode or FieldInsnNode");
            }
        }
    }
}

