/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.google.common.base.Charsets;
import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.core.api.LoadableModFile;
import com.mumfrey.liteloader.interfaces.LoadableFile;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.ModularEnumerator;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class EnumeratorModuleFolder
implements FilenameFilter,
EnumeratorModule {
    protected final Map<String, TreeSet<LoadableMod<File>>> versionOrderingSets = new HashMap<String, TreeSet<LoadableMod<File>>>();
    protected final List<LoadableMod<File>> loadableMods = new ArrayList<LoadableMod<File>>();
    protected LiteLoaderCoreAPI coreAPI;
    protected File directory;
    protected boolean readJarFiles;
    protected boolean loadTweaks;
    protected boolean forceInjection;
    protected final boolean loadTweakJars;

    public EnumeratorModuleFolder(LiteLoaderCoreAPI coreAPI, File directory, boolean loadTweakJars) {
        this.coreAPI = coreAPI;
        this.directory = directory;
        this.loadTweakJars = loadTweakJars;
    }

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
        this.loadTweaks = properties.loadTweaksEnabled();
        this.readJarFiles = properties.getAndStoreBooleanProperty("search.jarfiles", true);
        this.forceInjection = properties.getAndStoreBooleanProperty("forceInjection", false);
        this.coreAPI.writeDiscoverySettings();
    }

    @Override
    public void writeSettings(LoaderEnvironment environment, LoaderProperties properties) {
        properties.setBooleanProperty("search.jarfiles", this.readJarFiles);
        properties.setBooleanProperty("forceInjection", this.forceInjection);
    }

    public String toString() {
        return this.directory.getAbsolutePath();
    }

    public File getDirectory() {
        return this.directory;
    }

    public List<LoadableMod<File>> getLoadableMods() {
        return this.loadableMods;
    }

    @Override
    public boolean accept(File dir, String fileName) {
        if ((fileName = fileName.toLowerCase()).endsWith(".litemod.zip")) {
            LiteLoaderLogger.warning("Found %s with unsupported extension .litemod.zip. Please change file extension to .litemod to allow this file to be loaded!", fileName);
            return true;
        }
        return fileName.endsWith(".litemod") || fileName.endsWith(".jar");
    }

    @Override
    public void enumerate(ModularEnumerator enumerator, String profile) {
        if (this.directory.exists() && this.directory.isDirectory()) {
            LiteLoaderLogger.info("Discovering valid mod files in folder %s", this.directory.getPath());
            this.findValidFiles(enumerator);
            this.sortAndRegisterFiles(enumerator);
        }
    }

    private void findValidFiles(ModularEnumerator enumerator) {
        for (File file : this.directory.listFiles(this.getFilenameFilter())) {
            LoadableFile candidateFile = new LoadableFile(file);
            candidateFile.setForceInjection(this.forceInjection);
            try {
                this.inspectFile(enumerator, candidateFile);
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning(ex, "An error occurred whilst inspecting %s", candidateFile);
            }
        }
    }

    protected void inspectFile(ModularEnumerator enumerator, LoadableFile candidateFile) {
        if (this.isValidFile(enumerator, candidateFile)) {
            String metaData = candidateFile.getFileContents("litemod.json", Charsets.UTF_8);
            if (metaData != null) {
                LoadableMod<File> modFile = this.getModFile(candidateFile, metaData);
                this.addModFile(enumerator, modFile);
                return;
            }
            if (this.isValidTweakContainer(candidateFile)) {
                TweakContainer<File> container = this.getTweakFile(candidateFile);
                this.addTweakFile(enumerator, container);
                return;
            }
            LiteLoaderLogger.info("Ignoring %s", candidateFile);
        }
    }

    protected boolean isValidFile(ModularEnumerator enumerator, LoadableFile candidateFile) {
        String filename = candidateFile.getName().toLowerCase();
        if (filename.endsWith(".litemod.zip")) {
            enumerator.registerBadContainer(candidateFile, "Invalid file extension .litemod.zip");
            return false;
        }
        if (filename.endsWith(".litemod")) {
            return true;
        }
        if (filename.endsWith(".jar")) {
            Set<String> modSystems = candidateFile.getModSystems();
            boolean hasLiteLoader = modSystems.contains("LiteLoader");
            if (modSystems.size() > 0) {
                LiteLoaderLogger.info("%s supports mod systems %s", candidateFile, modSystems);
                if (!hasLiteLoader) {
                    return false;
                }
            }
            return this.loadTweakJars || this.readJarFiles || hasLiteLoader;
        }
        return false;
    }

    protected boolean isValidTweakContainer(LoadableFile candidateFile) {
        return this.loadTweakJars && this.loadTweaks && candidateFile.getName().toLowerCase().endsWith(".jar");
    }

    protected FilenameFilter getFilenameFilter() {
        return this;
    }

    protected boolean isFileSupported(LoadableMod<File> modFile) {
        return LiteLoaderVersion.CURRENT.isVersionSupported(modFile.getTargetVersion());
    }

    protected LoadableMod<File> getModFile(LoadableFile candidateFile, String metaData) {
        return new LoadableModFile(candidateFile, metaData);
    }

    protected TweakContainer<File> getTweakFile(LoadableFile candidateFile) {
        return candidateFile;
    }

    protected void addModFile(ModularEnumerator enumerator, LoadableMod<File> modFile) {
        if (modFile.hasValidMetaData()) {
            if (this.isFileSupported(modFile)) {
                if (!this.versionOrderingSets.containsKey(modFile.getName())) {
                    this.versionOrderingSets.put(modFile.getModName(), new TreeSet());
                }
                LiteLoaderLogger.info("Considering valid mod file: %s", modFile);
                this.versionOrderingSets.get(modFile.getModName()).add(modFile);
            } else {
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Not adding invalid or version-mismatched mod file: %s", modFile);
                enumerator.registerBadContainer(modFile, "Version not supported");
            }
        }
    }

    protected void addTweakFile(ModularEnumerator enumerator, TweakContainer<File> container) {
        enumerator.registerTweakContainer(container);
    }

    protected void sortAndRegisterFiles(ModularEnumerator enumerator) {
        for (Map.Entry<String, TreeSet<LoadableMod<File>>> modFileEntry : this.versionOrderingSets.entrySet()) {
            LoadableMod<File> newestVersion = modFileEntry.getValue().iterator().next();
            this.registerFile(enumerator, newestVersion);
        }
        this.versionOrderingSets.clear();
    }

    protected void registerFile(ModularEnumerator enumerator, LoadableMod<File> modFile) {
        if (enumerator.registerModContainer(modFile)) {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Adding newest valid mod file '%s' at revision %.4f", modFile, Float.valueOf(modFile.getRevision()));
            this.loadableMods.add(modFile);
        } else {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Not adding valid mod file '%s', the specified mod is disabled or missing a required dependency", modFile);
        }
        if (this.loadTweaks) {
            try {
                if (modFile instanceof TweakContainer) {
                    this.addTweakFile(enumerator, (TweakContainer)((Object)modFile));
                }
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning("Error adding tweaks from '%s'", modFile);
            }
        }
    }

    @Override
    public void injectIntoClassLoader(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info("Injecting external mods into class path...", new Object[0]);
        for (LoadableMod<File> loadableMod : this.loadableMods) {
            try {
                if (!loadableMod.injectIntoClassPath(classLoader, false)) continue;
                LiteLoaderLogger.info("Successfully injected mod file '%s' into classpath", loadableMod);
            }
            catch (MalformedURLException ex) {
                LiteLoaderLogger.warning("Error injecting '%s' into classPath. The mod will not be loaded", loadableMod);
            }
        }
    }

    @Override
    public void registerMods(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Discovering mods in valid mod files...", new Object[0]);
        LoadingProgress.incTotalLiteLoaderProgress(this.loadableMods.size());
        for (LoadableMod<File> modFile : this.loadableMods) {
            LoadingProgress.incLiteLoaderProgress("Searching for mods in " + modFile.getModName() + "...");
            LiteLoaderLogger.info("Searching %s...", modFile);
            try {
                enumerator.registerModsFrom(modFile, true);
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning("Error encountered whilst searching in %s...", modFile);
            }
        }
    }
}

