/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.exceptions.UnregisteredChannelException;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.permissions.PermissionsManagerServer;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.List;

public class ServerPluginChannels
extends PluginChannels<ServerPluginChannelListener> {
    private static ServerPluginChannels instance;

    public ServerPluginChannels() {
        if (instance != null) {
            InstantiationException inner = new InstantiationException("Only a single instance of ServerPluginChannels is allowed");
            throw new RuntimeException("Plugin Channels Startup Error", inner);
        }
        instance = this;
    }

    @Override
    protected FastIterableDeque<ServerPluginChannelListener> createHandlerList() {
        return new HandlerList<ServerPluginChannelListener>(ServerPluginChannelListener.class);
    }

    public static ServerPluginChannels getInstance() {
        return instance;
    }

    @Override
    public void initProvider() {
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(ServerPluginChannelListener.class);
    }

    void addServerPluginChannelListener(ServerPluginChannelListener pluginChannelListener) {
        super.addPluginChannelListener(pluginChannelListener);
    }

    void onServerStartup() {
        this.clearPluginChannels(null);
        for (ServerPluginChannelListener pluginChannelListener : this.pluginChannelListeners) {
            this.addPluginChannelsFor(pluginChannelListener);
        }
    }

    void onPlayerJoined(ls player) {
        this.sendRegisteredPluginChannels(player);
    }

    public void onPluginChannelMessage(er netHandler, ir customPayload) {
        if (customPayload != null && customPayload.a() != null) {
            String channel = customPayload.a();
            eo data = customPayload.b();
            ls sender = ((mc)netHandler).b;
            this.onPluginChannelMessage(sender, channel, data);
        }
    }

    private final void onPluginChannelMessage(ls sender, String channel, eo data) {
        if ("REGISTER".equals(channel)) {
            this.onRegisterPacketReceived(data);
        } else if (this.pluginChannels.containsKey(channel)) {
            try {
                PermissionsManagerServer permissionsManager = LiteLoader.getServerPermissionsManager();
                if (permissionsManager != null) {
                    permissionsManager.onCustomPayload(sender, channel, data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onModPacketReceived(sender, channel, data);
        }
    }

    protected void onModPacketReceived(ls sender, String channel, eo data) {
        for (ServerPluginChannelListener pluginChannelListener : (List)this.pluginChannels.get(channel)) {
            try {
                pluginChannelListener.onCustomPayload(sender, channel, data);
            }
            catch (Exception ex) {
                int failCount = 1;
                if (this.faultingPluginChannelListeners.containsKey(pluginChannelListener)) {
                    failCount = (Integer)this.faultingPluginChannelListeners.get(pluginChannelListener) + 1;
                }
                if (failCount >= 1000) {
                    LiteLoaderLogger.warning("Plugin channel listener %s exceeded fault threshold on channel %s with %s", pluginChannelListener.getName(), channel, ex.getClass().getSimpleName());
                    this.faultingPluginChannelListeners.remove(pluginChannelListener);
                    continue;
                }
                this.faultingPluginChannelListeners.put(pluginChannelListener, failCount);
            }
        }
    }

    protected void sendRegisteredPluginChannels(ls player) {
        try {
            eo registrationData = this.getRegistrationData();
            if (registrationData != null) {
                this.sendRegistrationData(player, registrationData);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning(ex, "Error dispatching REGISTER packet to client %s", player.i_());
        }
    }

    private void sendRegistrationData(ls recipient, eo registrationData) {
        ServerPluginChannels.dispatch(recipient, new gj("REGISTER", registrationData));
    }

    public static boolean sendMessage(ls recipient, String channel, eo data, PluginChannels.ChannelPolicy policy) {
        if (instance != null) {
            return instance.send(recipient, channel, data, policy);
        }
        return false;
    }

    private boolean send(ls recipient, String channel, eo data, PluginChannels.ChannelPolicy policy) {
        if (recipient == null) {
            return false;
        }
        if (channel == null || channel.length() > 16 || "REGISTER".equals(channel) || "UNREGISTER".equals(channel)) {
            throw new RuntimeException("Invalid channel name specified");
        }
        if (!policy.allows(this, channel)) {
            if (policy.isSilent()) {
                return false;
            }
            throw new UnregisteredChannelException(channel);
        }
        gj payload = new gj(channel, data);
        return ServerPluginChannels.dispatch(recipient, payload);
    }

    static boolean dispatch(ls recipient, gj payload) {
        try {
            if (recipient != null && recipient.a != null) {
                recipient.a.a((fh)payload);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

