/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class Proxy {
    private static LiteLoaderEventBroker<?, ?> broker;

    protected Proxy() {
    }

    protected static void onStartupComplete() {
        broker = LiteLoaderEventBroker.broker;
        if (broker == null) {
            throw new RuntimeException("LiteLoader failed to start up properly. The game is in an unstable state and must shut down now. Check the developer log for startup errors");
        }
    }

    public static void onInitializePlayerConnection(mn source, em netManager, ls player) {
        broker.onInitializePlayerConnection(source, netManager, player);
    }

    public static void onPlayerLogin(mn source, ls player) {
        broker.onPlayerLogin(source, player);
    }

    public static void onPlayerLogout(mn source, ls player) {
        broker.onPlayerLogout(source, player);
    }

    public static void onSpawnPlayer(CallbackInfoReturnable<ls> cir, mn source, GameProfile profile) {
        broker.onSpawnPlayer(source, cir.getReturnValue(), profile);
    }

    public static void onRespawnPlayer(CallbackInfoReturnable<ls> cir, mn source, ls oldPlayer, int dimension, boolean won) {
        broker.onRespawnPlayer(source, cir.getReturnValue(), oldPlayer, dimension, won);
    }

    public static void onServerTick(MinecraftServer mcServer) {
        broker.onServerTick(mcServer);
    }

    public static void onPlaceBlock(CallbackInfo ci, mc netHandler, ji packet) {
    }

    public static void onClickedAir(CallbackInfo ci, mc netHandler, jf packet) {
        if (!broker.onClickedAir(LiteLoaderEventBroker.InteractType.LEFT_CLICK, netHandler.b, packet.a())) {
            ci.cancel();
        }
    }

    public static void onPlayerDigging(CallbackInfo ci, mc netHandler, iy packet) {
        iy.a action = packet.c();
        ls player = netHandler.b;
        if (action == iy.a.a) {
            if (!broker.onPlayerDigging(LiteLoaderEventBroker.InteractType.DIG_BLOCK_MAYBE, player, netHandler, packet.a())) {
                ci.cancel();
            }
        } else if (action == iy.a.b || action == iy.a.c) {
            broker.onPlayerDigging(LiteLoaderEventBroker.InteractType.DIG_BLOCK_END, player, netHandler, packet.a());
        } else if (action == iy.a.g && !broker.onPlayerSwapItems(player)) {
            ci.cancel();
        }
    }

    public static void onRightClickBlock(CallbackInfoReturnable<qo> ci, zj player, aht world, adq stack, qm hand, cl pos, cs side, float offsetX, float offsetY, float offsetZ) {
        if (!(player instanceof ls)) {
            return;
        }
        if (!broker.onUseItem((ls)player, hand, stack, pos, side)) {
            ci.setReturnValue(qo.c);
        }
    }

    public static void postRightClickBlock(CallbackInfoReturnable<qo> cir, zj player, aht world, adq stack, qm hand, cl pos, cs side, float offsetX, float offsetY, float offsetZ) {
        if (!(player instanceof ls)) {
            return;
        }
        System.err.printf("@@ postRightClickBlock: %s\n", cir.getReturnValue());
    }

    public static void onRightClick(CallbackInfoReturnable<qo> cir, zj player, aht worldIn, adq stack, qm hand) {
        if (!(player instanceof ls)) {
            return;
        }
        if (!broker.onClickedAir(LiteLoaderEventBroker.InteractType.RIGHT_CLICK, (ls)player, hand)) {
            cir.setReturnValue(qo.c);
        }
    }

    public static void onBlockClicked(CallbackInfo ci, lt manager, cl pos, cs side) {
        if (!broker.onBlockClicked(pos, side, manager)) {
            ci.cancel();
        }
    }

    public static void onPlayerMoved(CallbackInfo ci, mc netHandler, iu packet, lq world, double oldPosX, double oldPosY, double oldPosZ) {
        if (!broker.onPlayerMove(netHandler, packet, netHandler.b, world)) {
            ci.cancel();
        }
    }

    public static void onPlayerMoved(CallbackInfo ci, mc netHandler, iu packet, lq world) {
        if (!broker.onPlayerMove(netHandler, packet, netHandler.b, world)) {
            ci.cancel();
        }
    }
}

