/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.transformers.ClassTransformer;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MinecraftTransformer
extends ClassTransformer {
    private static final String TWEAKCLASS = LiteLoaderTweaker.class.getName().replace('.', '/');

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (Obf.Minecraft.name.equals(transformedName) || Obf.Minecraft.obf.equals(transformedName)) {
            ClassNode classNode = this.readClass(basicClass, true);
            for (MethodNode method : classNode.methods) {
                if (!Obf.startGame.obf.equals(method.name) && !Obf.startGame.srg.equals(method.name) && !Obf.startGame.name.equals(method.name)) continue;
                this.transformStartGame(method);
            }
            return this.writeClass(classNode);
        }
        return basicClass;
    }

    private void transformStartGame(MethodNode method) {
        InsnList insns = new InsnList();
        boolean found = false;
        for (AbstractInsnNode insn : method.instructions) {
            insns.add(insn);
            if (insn instanceof TypeInsnNode && insn.getOpcode() == 187 && insns.getLast() != null) {
                TypeInsnNode typeNode = (TypeInsnNode)insn;
                if (!found && (Obf.EntityRenderer.obf.equals(typeNode.desc) || Obf.EntityRenderer.ref.equals(typeNode.desc))) {
                    LiteLoaderLogger.info("MinecraftTransformer found INIT injection point, this is good.", new Object[0]);
                    found = true;
                    insns.add((AbstractInsnNode)new MethodInsnNode(184, TWEAKCLASS, Obf.init.name, "()V", false));
                    insns.add((AbstractInsnNode)new MethodInsnNode(184, TWEAKCLASS, Obf.postInit.name, "()V", false));
                }
            }
            if (!LiteLoaderTweaker.loadingBarEnabled()) continue;
            if (insn instanceof LdcInsnNode) {
                LdcInsnNode ldcInsn = (LdcInsnNode)insn;
                if ("textures/blocks".equals(ldcInsn.cst)) {
                    insns.add((AbstractInsnNode)new MethodInsnNode(184, Obf.LoadingBar.ref, "initTextures", "()V", false));
                }
            }
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Obf.LoadingBar.ref, "incrementProgress", "()V", false));
        }
        method.instructions = insns;
        if (!found) {
            LiteLoaderLogger.severe("MinecraftTransformer failed to find INIT injection point, the game will probably crash pretty soon.", new Object[0]);
        }
    }
}

