/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui.modlist;

import com.google.common.base.Strings;
import com.mumfrey.liteloader.client.api.LiteLoaderBrandingProvider;
import com.mumfrey.liteloader.client.gui.GuiSimpleScrollBar;
import com.mumfrey.liteloader.client.gui.modlist.ModListEntry;
import com.mumfrey.liteloader.client.util.render.IconAbsolute;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.gl.GL;
import com.mumfrey.liteloader.gl.GLClippingPlanes;
import com.mumfrey.liteloader.util.render.IconTextured;

public class GuiModInfoPanel
extends bct {
    private static final int TITLE_COLOUR = -1;
    private static final int AUTHORS_COLOUR = -1;
    private static final int DIVIDER_COLOUR = -6710887;
    private static final int DESCRIPTION_COLOUR = -1;
    private static final IconAbsolute infoIcon = new IconAbsolute(LiteLoaderBrandingProvider.ABOUT_TEXTURE, "Info", 12, 12, 146.0f, 92.0f, 158.0f, 104.0f);
    private final ModListEntry owner;
    private final bcr fontRenderer;
    private final int brandColour;
    private final ModInfo<?> modInfo;
    private GuiSimpleScrollBar scrollBar = new GuiSimpleScrollBar();
    private boolean mouseOverPanel;
    private boolean mouseOverScrollBar;
    private boolean showHelp;
    private String helpTitle;
    private String helpText;

    public GuiModInfoPanel(ModListEntry owner, bcr fontRenderer, int brandColour, ModInfo<?> modInfo) {
        this.owner = owner;
        this.fontRenderer = fontRenderer;
        this.brandColour = brandColour;
        this.modInfo = modInfo;
    }

    public void draw(int mouseX, int mouseY, float partialTicks, int xPosition, int yPosition, int width, int height) {
        int bottom = height + yPosition;
        int yPos = yPosition + 2;
        this.mouseOverPanel = this.isMouseOver(mouseX, mouseY, xPosition, yPos, width, height);
        this.fontRenderer.a(this.owner.getTitleText(), xPosition + 5, yPos, -1);
        this.fontRenderer.a(this.owner.getVersionText(), xPosition + 5, yPos += 10, -6710887);
        GuiModInfoPanel.a((int)(xPosition + 5), (int)(yPos += 10), (int)(xPosition + width), (int)(yPos + 1), (int)-6710887);
        this.fontRenderer.a(bwl.a((String)"gui.about.authors", (Object[])new Object[0]) + ": \u00a77" + this.modInfo.getAuthor(), xPosition + 5, yPos += 4, -1);
        yPos += 10;
        if (!Strings.isNullOrEmpty((String)this.modInfo.getURL())) {
            this.fontRenderer.a(this.modInfo.getURL(), xPosition + 5, yPos, 0xB0FFFFFF & this.brandColour);
            yPos += 10;
        }
        GuiModInfoPanel.a((int)(xPosition + 5), (int)yPos, (int)(xPosition + width), (int)(yPos + 1), (int)-6710887);
        GuiModInfoPanel.a((int)(xPosition + 5), (int)(bottom - 1), (int)(xPosition + width), (int)bottom, (int)-6710887);
        GLClippingPlanes.glEnableClipping(-1, -1, yPos += 4, bottom - 3);
        int scrollHeight = bottom - yPos - 3;
        int contentHeight = this.drawContent(xPosition, width, yPos);
        this.scrollBar.setMaxValue(contentHeight - scrollHeight);
        this.scrollBar.drawScrollBar(mouseX, mouseY, partialTicks, xPosition + width - 5, yPos, 5, scrollHeight, contentHeight);
        this.mouseOverScrollBar = this.isMouseOver(mouseX, mouseY, xPosition + width - 5, yPos, 5, scrollHeight);
    }

    private int drawContent(int xPosition, int width, int yPos) {
        yPos -= this.scrollBar.getValue();
        if (this.showHelp) {
            this.drawIcon(xPosition + 3, yPos, infoIcon);
            this.fontRenderer.a(this.helpTitle, xPosition + 17, yPos += 2, this.brandColour);
            return this.drawText(xPosition + 17, width - 24, yPos += 12, this.helpText, -1) + 15;
        }
        return this.drawText(xPosition + 5, width - 11, yPos, this.modInfo.getDescription(), -1);
    }

    protected void drawIcon(int xPosition, int yPosition, IconTextured icon) {
        GL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        bcd.z().N().a(icon.getTextureResource());
        GL.glEnableBlend();
        this.b(xPosition, yPosition, icon.getUPos(), icon.getVPos(), icon.getIconWidth(), icon.getIconHeight());
        GL.glDisableBlend();
    }

    private int drawText(int xPosition, int width, int yPos, String text, int colour) {
        int totalHeight = this.fontRenderer.b(text, width);
        this.fontRenderer.a(text, xPosition, yPos, width, colour);
        return totalHeight;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height;
    }

    public void mousePressed() {
        if (this.mouseOverScrollBar) {
            this.scrollBar.setDragging(true);
        }
    }

    public void mouseReleased() {
        this.scrollBar.setDragging(false);
    }

    public boolean mouseWheelScrolled(int mouseWheelDelta) {
        if (this.mouseOverPanel) {
            this.scrollBar.offsetValue(-mouseWheelDelta / 8);
            return true;
        }
        return false;
    }

    public void displayHelpMessage(String title, String text) {
        this.showHelp = true;
        this.helpTitle = bwl.a((String)title, (Object[])new Object[0]);
        this.helpText = bwl.a((String)text, (Object[])new Object[0]);
        this.scrollBar.setValue(0);
    }

    public void clearHelpMessage() {
        this.showHelp = false;
    }
}

