/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.client.gui.GuiCheckbox;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.interfaces.PanelManager;

class GuiPanelSettings
extends GuiPanel {
    private GuiLiteLoaderPanel parentScreen;
    private GuiCheckbox chkShowTab;
    private GuiCheckbox chkNoHide;
    private GuiCheckbox chkForceUpdate;
    private boolean hide;
    private String[] helpText = new String[5];

    GuiPanelSettings(GuiLiteLoaderPanel parentScreen, bcd minecraft) {
        super(minecraft);
        this.parentScreen = parentScreen;
        this.helpText[0] = bwl.a((String)"gui.settings.showtab.help1", (Object[])new Object[0]);
        this.helpText[1] = bwl.a((String)"gui.settings.showtab.help2", (Object[])new Object[0]);
        this.helpText[2] = bwl.a((String)"gui.settings.notabhide.help1", (Object[])new Object[0]);
        this.helpText[3] = bwl.a((String)"gui.settings.forceupdate.help1", (Object[])new Object[0]);
        this.helpText[4] = bwl.a((String)"gui.settings.forceupdate.help2", (Object[])new Object[0]);
    }

    @Override
    public void close() {
        this.hide = true;
    }

    @Override
    boolean isCloseRequested() {
        boolean hide = this.hide;
        this.hide = false;
        return hide;
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        this.controls.add(new bcx(-1, this.width - 99 - 12, this.height - 40 + 9, 100, 20, bwl.a((String)"gui.done", (Object[])new Object[0])));
        this.chkShowTab = new GuiCheckbox(0, 34, 90, bwl.a((String)"gui.settings.showtab.label", (Object[])new Object[0]));
        this.controls.add(this.chkShowTab);
        this.chkNoHide = new GuiCheckbox(1, 34, 128, bwl.a((String)"gui.settings.notabhide.label", (Object[])new Object[0]));
        this.controls.add(this.chkNoHide);
        this.chkForceUpdate = new GuiCheckbox(2, 34, 158, bwl.a((String)"gui.settings.forceupdate.label", (Object[])new Object[0]));
        this.controls.add(this.chkForceUpdate);
        this.updateCheckBoxes();
    }

    private void updateCheckBoxes() {
        PanelManager panelManager = LiteLoader.getModPanelManager();
        this.chkShowTab.checked = panelManager.isTabVisible();
        this.chkNoHide.checked = panelManager.isTabAlwaysExpanded();
        this.chkForceUpdate.checked = panelManager.isForceUpdateEnabled();
    }

    private void updateSettings() {
        PanelManager panelManager = LiteLoader.getModPanelManager();
        panelManager.setTabVisible(this.chkShowTab.checked);
        panelManager.setTabAlwaysExpanded(this.chkNoHide.checked);
        panelManager.setForceUpdateEnabled(this.chkForceUpdate.checked);
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        this.parentScreen.drawInfoPanel(mouseX, mouseY, partialTicks, 0, 38);
        bcr fontRenderer = this.mc.k;
        int brandColour = this.parentScreen.getBrandColour();
        fontRenderer.a(this.helpText[0], 50, 104, brandColour);
        fontRenderer.a(this.helpText[1], 50, 114, brandColour);
        fontRenderer.a(this.helpText[2], 50, 142, brandColour);
        fontRenderer.a(this.helpText[3], 50, 172, brandColour);
        fontRenderer.a(this.helpText[4], 50, 182, brandColour);
        super.draw(mouseX, mouseY, partialTicks);
    }

    @Override
    void actionPerformed(bcx control) {
        if (control.k == -1) {
            this.close();
            return;
        }
        if (control instanceof GuiCheckbox) {
            ((GuiCheckbox)control).checked = !((GuiCheckbox)control).checked;
            this.updateSettings();
        }
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.close();
        }
    }

    @Override
    void onTick() {
    }

    @Override
    void onHidden() {
    }

    @Override
    void onShown() {
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
    }
}

