/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.client.gui.GuiCheckbox;
import com.mumfrey.liteloader.client.gui.GuiHoverLabel;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.client.gui.GuiScrollPanel;
import com.mumfrey.liteloader.client.gui.ScrollPanelContent;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.gl.GL;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import com.mumfrey.liteloader.util.net.LiteLoaderLogUpload;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;

class GuiPanelLiteLoaderLog
extends GuiPanel
implements ScrollPanelContent {
    private static boolean useNativeRes = true;
    private GuiScrollPanel scrollPane;
    private List<String> logEntries = new ArrayList<String>();
    private long logIndex = -1L;
    private GuiCheckbox chkScale;
    private float guiScale;
    private bcx btnUpload;
    private LiteLoaderLogUpload logUpload;
    private String logURL;
    private int throb;
    private boolean closeDialog;
    private GuiLiteLoaderPanel parent;
    private int debugInfoTimer = 0;

    GuiPanelLiteLoaderLog(bcd minecraft, GuiLiteLoaderPanel parent) {
        super(minecraft);
        this.parent = parent;
        this.scrollPane = new GuiScrollPanel(minecraft, this, 12, 26, this.width - 24, this.height - 26 - 40);
    }

    private void updateLog() {
        this.logEntries = LiteLoaderLogger.getLogTail();
        this.logIndex = LiteLoaderLogger.getLogIndex();
        this.scrollPane.updateHeight();
        this.scrollPane.scrollToBottom();
    }

    @Override
    public int getScrollPanelContentHeight(GuiScrollPanel source) {
        return (int)((float)(this.logEntries.size() * 10) / (this.chkScale.checked ? this.guiScale : 1.0f));
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        this.controls.add(new bcx(0, this.width - 59 - 12, this.height - 40 + 9, 60, 20, bwl.a((String)"gui.done", (Object[])new Object[0])));
        this.btnUpload = new bcx(1, this.width - 145 - 12, this.height - 40 + 9, 80, 20, bwl.a((String)"gui.log.postlog", (Object[])new Object[0]));
        this.controls.add(this.btnUpload);
        this.chkScale = new GuiCheckbox(2, 12, this.height - 40 + 15, bwl.a((String)"gui.log.scalecheckbox", (Object[])new Object[0]));
        this.controls.add(this.chkScale);
        this.chkScale.checked = useNativeRes;
        bcv res = new bcv(this.mc);
        this.guiScale = res.e();
        this.scrollPane.setSizeAndPosition(12, 26, this.width - 24, this.height - 26 - 40);
        this.updateLog();
    }

    @Override
    void onShown() {
    }

    @Override
    void onHidden() {
    }

    @Override
    void onTick() {
        ++this.throb;
        if (LiteLoaderLogger.getLogIndex() > this.logIndex) {
            this.updateLog();
        }
        if (this.logUpload != null && this.logUpload.isCompleted()) {
            this.logURL = this.logUpload.getLogUrl().trim();
            this.logUpload = null;
            int xMid = this.width / 2;
            if (this.logURL.startsWith("http:")) {
                LiteLoaderLogger.info("Log file upload succeeded, url is %s", this.logURL);
                int urlWidth = this.mc.k.a(this.logURL);
                this.controls.add(new GuiHoverLabel(3, xMid - urlWidth / 2, this.height / 2, this.mc.k, "\u00a7n" + this.logURL, this.parent.getBrandColour()));
            } else {
                LiteLoaderLogger.info("Log file upload failed, reason is %s", this.logURL);
            }
            this.controls.add(new bcx(4, xMid - 40, this.height - 40 - 12 - 24, 80, 20, bwl.a((String)"gui.log.closedialog", (Object[])new Object[0])));
        }
        if (this.closeDialog) {
            this.closeDialog = false;
            this.logURL = null;
            this.setSize(this.width, this.height);
        }
        if (Keyboard.isKeyDown((int)61)) {
            ++this.debugInfoTimer;
            if (this.debugInfoTimer == 60) {
                LiteLoader.dumpDebugInfo();
            }
        } else {
            this.debugInfoTimer = 0;
        }
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        this.mc.k.a(bwl.a((String)"gui.log.title", (Object[])new Object[0]), 12, 12, -1);
        GuiPanelLiteLoaderLog.a((int)12, (int)22, (int)(this.width - 12), (int)23, (int)-6710887);
        GuiPanelLiteLoaderLog.a((int)12, (int)(this.height - 40 + 2), (int)(this.width - 12), (int)(this.height - 40 + 3), (int)-6710887);
        this.scrollPane.draw(mouseX, mouseY, partialTicks);
        int xMid = this.width / 2;
        int yMid = this.height / 2;
        if (this.logUpload != null || this.logURL != null) {
            GuiPanelLiteLoaderLog.a((int)24, (int)38, (int)(this.width - 12 - 12), (int)(this.height - 40 - 12), (int)-1073741824);
            if (this.logUpload != null) {
                this.a(this.mc.k, bwl.a((String)"gui.log.uploading", (Object[])new Object[0]), xMid, yMid - 10, -1);
                this.drawThrobber(xMid - 90, yMid - 14, this.throb);
            } else if (this.logURL.startsWith("http:")) {
                this.a(this.mc.k, bwl.a((String)"gui.log.uploadsuccess", (Object[])new Object[0]), xMid, yMid - 14, -11141291);
            } else {
                this.a(this.mc.k, bwl.a((String)"gui.log.uploadfailed", (Object[])new Object[0]), xMid, yMid - 10, -43691);
            }
        }
        super.draw(mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawScrollPanelContent(GuiScrollPanel source, int mouseX, int mouseY, float partialTicks, int scrollAmount, int visibleHeight) {
        int yPos = 0;
        int height = this.innerHeight;
        if (this.chkScale.checked) {
            float scale = 1.0f / this.guiScale;
            GL.glScalef(scale, scale, scale);
            height = (int)((float)height * this.guiScale);
            scrollAmount = (int)((float)scrollAmount * this.guiScale);
        }
        for (String logLine : this.logEntries) {
            if (yPos > scrollAmount - 10 && yPos <= scrollAmount + height) {
                this.mc.k.a(logLine, 0, yPos, this.getMessageColour(logLine.toLowerCase().substring(11)));
            }
            yPos += 10;
        }
    }

    @Override
    public void scrollPanelMousePressed(GuiScrollPanel source, int mouseX, int mouseY, int mouseButton) {
    }

    private int getMessageColour(String logLine) {
        if (logLine.startsWith("liteloader")) {
            return 0xFFFFFF;
        }
        if (logLine.startsWith("active pack:")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("success")) {
            return 0x55FF55;
        }
        if (logLine.startsWith("discovering")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("searching")) {
            return 43520;
        }
        if (logLine.startsWith("considering")) {
            return 0xFFAA00;
        }
        if (logLine.startsWith("not adding")) {
            return 0xFF5555;
        }
        if (logLine.startsWith("mod in")) {
            return 0xAA0000;
        }
        if (logLine.startsWith("error")) {
            return 0xAA0000;
        }
        if (logLine.startsWith("adding newest")) {
            return 0x5555FF;
        }
        if (logLine.startsWith("found")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("discovered")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("setting up")) {
            return 0xAA00AA;
        }
        if (logLine.startsWith("adding \"")) {
            return 0xAA00AA;
        }
        if (logLine.startsWith("injecting")) {
            return 0xFF55FF;
        }
        if (logLine.startsWith("loading")) {
            return 0x5555FF;
        }
        if (logLine.startsWith("initialising")) {
            return 0x55FFFF;
        }
        if (logLine.startsWith("calling late")) {
            return 43690;
        }
        if (logLine.startsWith("dependency check")) {
            return 0xFFAA00;
        }
        if (logLine.startsWith("dependency")) {
            return 0xFF5500;
        }
        if (logLine.startsWith("mod name collision")) {
            return 0xAA0000;
        }
        if (logLine.startsWith("registering discovery module")) {
            return 0x55FF55;
        }
        if (logLine.startsWith("registering interface provider")) {
            return 0xFFAA00;
        }
        if (logLine.startsWith("mod file '")) {
            return 0xFFAA00;
        }
        if (logLine.startsWith("classtransformer '")) {
            return 0x5555FF;
        }
        if (logLine.startsWith("tweakClass '")) {
            return 0x5555FF;
        }
        if (logLine.startsWith("baking listener list")) {
            return 43690;
        }
        if (logLine.startsWith("generating new event handler")) {
            return 0xFFFF55;
        }
        return 0xCCCCCC;
    }

    @Override
    public void actionPerformed(bcx control) {
        if (control.k == 0) {
            this.close();
        }
        if (control.k == 1) {
            this.postLog();
        }
        if (control.k == 2 && this.chkScale != null) {
            useNativeRes = this.chkScale.checked = !this.chkScale.checked;
            this.updateLog();
        }
        if (control.k == 3 && this.logURL != null) {
            this.openURI(URI.create(this.logURL));
        }
        if (control.k == 4) {
            this.closeDialog = true;
        }
    }

    @Override
    public void scrollPanelActionPerformed(GuiScrollPanel source, bcx control) {
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
        this.scrollPane.mouseWheelScrolled(mouseWheelDelta);
    }

    @Override
    void mousePressed(int mouseX, int mouseY, int mouseButton) {
        this.scrollPane.mousePressed(mouseX, mouseY, mouseButton);
        super.mousePressed(mouseX, mouseY, mouseButton);
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.scrollPane.mouseReleased(mouseX, mouseY, mouseButton);
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.close();
        }
        if (keyCode == 57) {
            this.actionPerformed(this.chkScale);
        }
        this.scrollPane.keyPressed(keyChar, keyCode);
    }

    private void postLog() {
        this.btnUpload.l = false;
        StringBuilder completeLog = new StringBuilder();
        for (String logLine : this.logEntries) {
            completeLog.append(logLine).append("\r\n");
        }
        LiteLoaderLogger.info("Uploading log file to liteloader...", new Object[0]);
        bck session = this.mc.K();
        this.logUpload = new LiteLoaderLogUpload(session.c(), session.b(), completeLog.toString());
        this.logUpload.start();
    }

    private void openURI(URI uri) {
        try {
            Class<?> desktop = Class.forName("java.awt.Desktop");
            Object instance = desktop.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktop.getMethod("browse", URI.class).invoke(instance, uri);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

