/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.api.CoreProvider;
import com.mumfrey.liteloader.client.GameEngineClient;
import com.mumfrey.liteloader.client.SoundHandlerReloadInhibitor;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.common.Resources;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.resources.InternalResourcePack;

public class LiteLoaderCoreProviderClient
implements CoreProvider {
    private final LoaderProperties properties;
    private boolean inhibitSoundManagerReload = true;
    private SoundHandlerReloadInhibitor soundHandlerReloadInhibitor;

    public LiteLoaderCoreProviderClient(LoaderProperties properties) {
        this.properties = properties;
    }

    @Override
    public void onInit() {
        this.inhibitSoundManagerReload = this.properties.getAndStoreBooleanProperty("soundManagerFix", true);
    }

    @Override
    public void onPostInit(GameEngine<?, ?> engine) {
        bwi resourceManager = (bwi)engine.getResources().getResourceManager();
        byv soundHandler = ((GameEngineClient)engine).getSoundHandler();
        this.soundHandlerReloadInhibitor = new SoundHandlerReloadInhibitor(resourceManager, soundHandler);
        if (this.inhibitSoundManagerReload) {
            this.soundHandlerReloadInhibitor.inhibit();
        }
        Resources<?, ?> resources = LiteLoader.getGameEngine().getResources();
        resources.registerResourcePack(new InternalResourcePack("LiteLoader", LiteLoader.class, "liteloader"));
    }

    @Override
    public void onPostInitComplete(LiteLoaderMods mods) {
    }

    @Override
    public void onStartupComplete() {
        if (this.soundHandlerReloadInhibitor != null && this.soundHandlerReloadInhibitor.isInhibited()) {
            this.soundHandlerReloadInhibitor.unInhibit(true);
        }
    }

    @Override
    public void onJoinGame(er netHandler, gu loginPacket) {
    }

    @Override
    public void onPostRender(int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void onTick(boolean clock, float partialTicks, boolean inGame) {
    }

    @Override
    public void onWorldChanged(aht world) {
    }

    @Override
    public void onShutDown() {
    }
}

