/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.lang.reflect.Method;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.obfuscation.SrgMethod;
import org.spongepowered.tools.MirrorUtils;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandler;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;

class AnnotatedMixinOverwriteHandler
extends AnnotatedMixinElementHandler {
    AnnotatedMixinOverwriteHandler(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        super(ap, mixin);
    }

    void registerOverwrite(ExecutableElement method, AnnotationMirror overwrite) {
        AnnotatedMixinElementHandler.AliasedElementName name = new AnnotatedMixinElementHandler.AliasedElementName(method, overwrite);
        this.validateTargetMethod(method, overwrite, name, "@Overwrite");
        this.checkConstraints(method, overwrite);
        if (!this.mixin.remap() || !this.validateSingleTarget("@Overwrite", method)) {
            return;
        }
        String mcpName = method.getSimpleName().toString();
        String mcpSignature = MirrorUtils.generateSignature(method);
        ObfuscationData<SrgMethod> obfData = this.obf.getObfMethod(new SrgMethod(this.mixin.getPrimaryTargetRef() + "/" + mcpName, mcpSignature));
        if (obfData.isEmpty()) {
            Diagnostic.Kind error = Diagnostic.Kind.ERROR;
            try {
                Method md = method.getClass().getMethod("isStatic", new Class[0]);
                if (((Boolean)md.invoke((Object)method, new Object[0])).booleanValue()) {
                    error = Diagnostic.Kind.WARNING;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.ap.printMessage(error, "No obfuscation mapping for @Overwrite method", method);
            return;
        }
        for (ObfuscationType type : obfData) {
            SrgMethod obfMethod = obfData.get(type);
            this.addMethodMapping(type, mcpName, obfMethod.getSimpleName(), mcpSignature, obfMethod.getDesc());
        }
        if (!"true".equalsIgnoreCase(this.ap.getOption("disableOverwriteChecker"))) {
            Diagnostic.Kind overwriteErrorKind = "error".equalsIgnoreCase(this.ap.getOption("overwriteErrorLevel")) ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            String javadoc = this.ap.getJavadocProvider().getJavadoc(method);
            if (javadoc == null) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing javadoc comment", method);
                return;
            }
            if (!javadoc.toLowerCase().contains("@author")) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing an @author tag", method);
            }
            if (!javadoc.toLowerCase().contains("@reason")) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing an @reason tag", method);
            }
        }
    }
}

