/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util;

import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.Input;
import com.mumfrey.liteloader.util.InputEvent;
import com.mumfrey.liteloader.util.InputHandler;
import com.mumfrey.liteloader.util.jinput.ComponentRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public final class InputManager
extends Input {
    private GameEngine<?, ?> engine;
    private nt profiler;
    private final File keyMapSettingsFile;
    private final Properties keyMapSettings = new Properties();
    private final List<avb> modKeyBindings = new ArrayList<avb>();
    private final Map<avb, Integer> storedModKeyBindings = new HashMap<avb, Integer>();
    private final ComponentRegistry jInputComponentRegistry;
    private final Map<Component, InputEvent> componentEvents = new HashMap<Component, InputEvent>();
    private Controller[] pollControllers = new Controller[0];

    public InputManager(LoaderEnvironment environment, LoaderProperties properties) {
        if (LiteLoader.getInstance() != null && LiteLoader.getInput() != null) {
            throw new IllegalStateException("Only one instance of Input is allowed, use LiteLoader.getInput() to get the active instance");
        }
        this.keyMapSettingsFile = new File(environment.getCommonConfigFolder(), "liteloader.keys.properties");
        this.jInputComponentRegistry = new ComponentRegistry();
        if (!properties.getAndStoreBooleanProperty("disableJInput", false)) {
            this.jInputComponentRegistry.enumerate();
        }
    }

    @Override
    public void onInit() {
        if (this.keyMapSettingsFile.exists()) {
            try {
                this.keyMapSettings.load(new FileReader(this.keyMapSettingsFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onPostInit(GameEngine<?, ?> engine) {
        this.engine = engine;
        this.profiler = engine.getProfiler();
    }

    @Override
    public void registerKeyBinding(avb binding) {
        List<avb> keyBindings = this.engine.getKeyBindings();
        if (!keyBindings.contains(binding)) {
            if (this.keyMapSettings.containsKey(binding.g())) {
                try {
                    int code = Integer.parseInt(this.keyMapSettings.getProperty(binding.g(), String.valueOf(binding.i())));
                    binding.b(code);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            keyBindings.add(binding);
            this.engine.setKeyBindings(keyBindings);
            this.modKeyBindings.add(binding);
            this.updateBinding(binding);
            this.storeBindings();
            avb.b();
        }
    }

    @Override
    public void unRegisterKeyBinding(avb binding) {
        List<avb> keyBindings = this.engine.getKeyBindings();
        if (keyBindings.contains(binding)) {
            keyBindings.remove(binding);
            this.engine.setKeyBindings(keyBindings);
            this.modKeyBindings.remove(binding);
            avb.b();
        }
    }

    @Override
    public void onTick(boolean clock, float partialTicks, boolean inGame) {
        this.profiler.a("keybindings");
        if (clock) {
            boolean updated = false;
            for (avb binding : this.modKeyBindings) {
                if (binding.i() == this.storedModKeyBindings.get(binding).intValue()) continue;
                this.updateBinding(binding);
                updated = true;
            }
            if (updated) {
                this.storeBindings();
            }
        }
        this.pollControllers();
        this.profiler.b();
    }

    private void updateBinding(avb binding) {
        this.keyMapSettings.setProperty(binding.g(), String.valueOf(binding.i()));
        this.storedModKeyBindings.put(binding, binding.i());
    }

    @Override
    public void onShutDown() {
        this.storeBindings();
    }

    @Override
    public void storeBindings() {
        try {
            this.keyMapSettings.store(new FileWriter(this.keyMapSettingsFile), "Mod key mappings for LiteLoader mods, stored here to avoid losing settings stored in options.txt");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.jInputComponentRegistry;
    }

    @Override
    public InputEvent getEvent(String descriptor, InputHandler handler) {
        if (handler == null) {
            return null;
        }
        Component component = this.jInputComponentRegistry.getComponent(descriptor);
        Controller controller = this.jInputComponentRegistry.getController(descriptor);
        return this.addEventHandler(controller, component, handler);
    }

    @Override
    public InputEvent[] getEvents(String descriptor, InputHandler handler) {
        ArrayList<InputEvent> events = new ArrayList<InputEvent>();
        Controller controller = this.jInputComponentRegistry.getController(descriptor);
        if (controller != null) {
            for (Component component : controller.getComponents()) {
                events.add(this.addEventHandler(controller, component, handler));
            }
        }
        return events.toArray(new InputEvent[0]);
    }

    private InputEvent addEventHandler(Controller controller, Component component, InputHandler handler) {
        if (controller != null && component != null && handler != null) {
            this.addController(controller);
            InputEvent event = new InputEvent(controller, component, handler);
            this.componentEvents.put(component, event.link(this.componentEvents.get(component)));
            return event;
        }
        return null;
    }

    private void addController(Controller controller) {
        Set<Controller> controllers = this.getActiveControllers();
        controllers.add(controller);
        this.setActiveControllers(controllers);
    }

    private Set<Controller> getActiveControllers() {
        HashSet<Controller> allControllers = new HashSet<Controller>();
        for (Controller controller : this.pollControllers) {
            allControllers.add(controller);
        }
        return allControllers;
    }

    private void setActiveControllers(Set<Controller> controllers) {
        this.pollControllers = controllers.toArray(new Controller[controllers.size()]);
    }

    private void pollControllers() {
        for (Controller controller : this.pollControllers) {
            controller.poll();
            EventQueue controllerQueue = controller.getEventQueue();
            Event event = new Event();
            while (controllerQueue.getNextEvent(event)) {
                Component cmp = event.getComponent();
                InputEvent inputEvent = this.componentEvents.get(cmp);
                if (inputEvent == null) continue;
                inputEvent.onEvent(event);
            }
        }
    }
}

