/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.json;

import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.json.InvalidEventJsonException;
import com.mumfrey.liteloader.transformers.event.json.JsonDescriptor;
import com.mumfrey.liteloader.transformers.event.json.JsonEvents;
import com.mumfrey.liteloader.transformers.event.json.JsonObfuscationTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonMethods {
    private final JsonObfuscationTable obfuscation;
    private final List<JsonDescriptor> descriptors;
    private Map<String, MethodInfo> methods = new HashMap<String, MethodInfo>();

    public JsonMethods(JsonObfuscationTable obfuscation, List<JsonDescriptor> descriptors) {
        this.obfuscation = obfuscation;
        this.descriptors = descriptors;
        this.parse();
    }

    private void parse() {
        if (this.descriptors != null) {
            for (JsonDescriptor descriptor : this.descriptors) {
                this.methods.put(descriptor.getKey(), descriptor.parse(this.obfuscation));
            }
        }
    }

    public MethodInfo get(String token) {
        String key = JsonEvents.parseToken(token);
        if (key == null) {
            throw new InvalidEventJsonException("\"" + token + "\" is not a valid token");
        }
        MethodInfo method = this.methods.get(key);
        if (method != null) {
            return method;
        }
        throw new InvalidEventJsonException("Could not locate method descriptor with token " + token);
    }
}

