/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.json;

import com.google.gson.annotations.SerializedName;
import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.json.InvalidEventJsonException;
import com.mumfrey.liteloader.transformers.event.json.JsonInjection;
import com.mumfrey.liteloader.transformers.event.json.JsonMethods;
import com.mumfrey.liteloader.transformers.event.json.ModEventInjectionTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JsonEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int nextEventID = 0;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="cancellable")
    private boolean cancellable;
    @SerializedName(value="priority")
    private int priority = 1000;
    @SerializedName(value="injections")
    private List<JsonInjection> jsonInjections;
    @SerializedName(value="listeners")
    private List<String> jsonListeners;
    private transient List<MethodInfo> listeners = new ArrayList<MethodInfo>();

    public String getName() {
        if (this.name == null) {
            this.name = "onUserEvent" + nextEventID++;
        }
        return this.name;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<MethodInfo> getListeners() {
        return this.listeners;
    }

    public void parse(JsonMethods methods) {
        this.parseInjectionPoints(methods);
        this.parseListeners(methods);
    }

    private void parseInjectionPoints(JsonMethods methods) {
        if (this.jsonInjections == null || this.jsonInjections.isEmpty()) {
            throw new InvalidEventJsonException("Event " + this.getName() + " does not have any defined injections");
        }
        for (JsonInjection injection : this.jsonInjections) {
            injection.parse(methods);
        }
    }

    private void parseListeners(JsonMethods methods) {
        if (this.jsonListeners == null || this.jsonListeners.isEmpty()) {
            throw new InvalidEventJsonException("Event " + this.getName() + " does not have any defined listeners");
        }
        for (String listener : this.jsonListeners) {
            this.listeners.add(methods.get(listener));
        }
    }

    public Event register(ModEventInjectionTransformer transformer) {
        Event event = Event.getOrCreate(this.getName(), this.isCancellable(), this.getPriority());
        for (JsonInjection injection : this.jsonInjections) {
            MethodInfo targetMethod = injection.getMethod();
            InjectionPoint injectionPoint = injection.getInjectionPoint();
            transformer.registerEvent(event, targetMethod, injectionPoint);
        }
        for (MethodInfo listener : this.listeners) {
            event.addListener(listener);
        }
        return event;
    }
}

