/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event;

import com.google.common.collect.Maps;
import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.ByteCodeUtilities;
import com.mumfrey.liteloader.transformers.ClassTransformer;
import com.mumfrey.liteloader.transformers.ObfProvider;
import com.mumfrey.liteloader.transformers.access.AccessorTransformer;
import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.ReadOnlyInsnList;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.CheckClassAdapter;

public final class EventTransformer
extends ClassTransformer {
    public static final boolean DUMP = Booleans.parseBoolean((String)System.getProperty("liteloader.debug.dump"), (boolean)false);
    public static final boolean VALIDATE = Booleans.parseBoolean((String)System.getProperty("liteloader.debug.validate"), (boolean)false);
    private static Map<String, Map<String, Map<Event, InjectionPoint>>> eventMappings = Maps.newHashMap();
    private static AccessorTransformer accessorTransformer;
    private int globalEventID = 0;

    static void addEvent(Event event, String className, String signature, InjectionPoint injectionPoint) {
        Map<Event, InjectionPoint> events;
        Map<String, Map<Event, InjectionPoint>> mappings = eventMappings.get(className);
        if (mappings == null) {
            mappings = new HashMap<String, Map<Event, InjectionPoint>>();
            eventMappings.put(className, mappings);
        }
        if ((events = mappings.get(signature)) == null) {
            events = new LinkedHashMap<Event, InjectionPoint>();
            mappings.put(signature, events);
        }
        events.put(event, injectionPoint);
    }

    static void addAccessor(String interfaceName) {
        EventTransformer.addAccessor(interfaceName, null);
    }

    static void addAccessor(String interfaceName, ObfProvider obfProvider) {
        if (accessorTransformer == null) {
            accessorTransformer = new AccessorTransformer(){

                @Override
                protected void addAccessors() {
                }
            };
        }
        accessorTransformer.addAccessor(interfaceName, obfProvider);
    }

    public final byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && eventMappings.containsKey(transformedName)) {
            return this.injectEvents(name, transformedName, basicClass, eventMappings.get(transformedName));
        }
        if (accessorTransformer != null) {
            return accessorTransformer.transform(name, transformedName, basicClass);
        }
        return basicClass;
    }

    private byte[] injectEvents(String name, String transformedName, byte[] basicClass, Map<String, Map<Event, InjectionPoint>> mappings) {
        if (mappings == null) {
            return basicClass;
        }
        ClassNode classNode = this.readClass(basicClass, true);
        for (MethodNode method : classNode.methods) {
            String signature = MethodInfo.generateSignature(method.name, method.desc);
            Map<Event, InjectionPoint> methodInjections = mappings.get(signature);
            if (methodInjections == null) continue;
            this.injectIntoMethod(classNode, signature, method, methodInjections);
        }
        if (accessorTransformer != null) {
            accessorTransformer.apply(name, transformedName, basicClass, classNode);
        }
        if (VALIDATE) {
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)writer));
        }
        byte[] bytes = this.writeClass(classNode);
        if (DUMP) {
            try {
                FileUtils.writeByteArrayToFile((File)new File(".classes/" + Obf.lookupMCPName(transformedName).replace('.', '/') + ".class"), (byte[])bytes);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return bytes;
    }

    void injectIntoMethod(ClassNode classNode, String signature, MethodNode method, Map<Event, InjectionPoint> methodInjections) {
        Map<AbstractInsnNode, Injection> injectionPoints = this.findInjectionPoints(classNode, method, methodInjections);
        for (Map.Entry<AbstractInsnNode, Injection> injectionPoint : injectionPoints.entrySet()) {
            this.injectEventsAt(classNode, method, injectionPoint.getKey(), injectionPoint.getValue());
        }
        for (Event event : methodInjections.keySet()) {
            event.notifyInjected(method.name, method.desc, classNode.name);
            event.detach();
        }
    }

    private Map<AbstractInsnNode, Injection> findInjectionPoints(ClassNode classNode, MethodNode method, Map<Event, InjectionPoint> methodInjections) {
        ReadOnlyInsnList insns = new ReadOnlyInsnList(method.instructions);
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>(32);
        LinkedHashMap<AbstractInsnNode, Injection> injectionPoints = new LinkedHashMap<AbstractInsnNode, Injection>();
        for (Map.Entry<Event, InjectionPoint> eventEntry : methodInjections.entrySet()) {
            Event event = eventEntry.getKey();
            event.attach(method);
            InjectionPoint injectionPoint = eventEntry.getValue();
            nodes.clear();
            if (!injectionPoint.find(method.desc, insns, nodes, event)) continue;
            for (AbstractInsnNode node : nodes) {
                Injection injection = (Injection)injectionPoints.get(node);
                if (injection == null) {
                    injection = new Injection(node, injectionPoint.captureLocals());
                    injectionPoints.put(node, injection);
                } else {
                    injection.checkCaptureLocals(injectionPoint);
                }
                if (injectionPoint.captureLocals() && !injection.hasLocals()) {
                    LocalVariableNode[] locals = ByteCodeUtilities.getLocalsAt(classNode, method, node);
                    injection.setLocals(locals);
                    if (injectionPoint.logLocals()) {
                        int startPos = ByteCodeUtilities.getFirstNonArgLocalIndex(method);
                        LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
                        LiteLoaderLogger.debug("Logging local variables for " + injectionPoint, new Object[0]);
                        for (int i = startPos; i < locals.length; ++i) {
                            LocalVariableNode local = locals[i];
                            if (local == null) continue;
                            LiteLoaderLogger.debug("    Local[%d] %s %s", i, ByteCodeUtilities.getTypeName(Type.getType((String)local.desc)), local.name);
                        }
                        LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
                    }
                }
                injection.add(event);
            }
        }
        return injectionPoints;
    }

    private void injectEventsAt(ClassNode classNode, MethodNode method, AbstractInsnNode injectionPoint, Injection injection) {
        Event head = injection.getHead();
        LiteLoaderLogger.Verbosity verbosity = head.isVerbose() ? LiteLoaderLogger.Verbosity.NORMAL : LiteLoaderLogger.Verbosity.VERBOSE;
        LiteLoaderLogger.info(verbosity, "Injecting %s[x%d] in %s in %s", head.getName(), injection.size(), method.name, ClassTransformer.getSimpleClassName(classNode));
        MethodNode handler = head.inject(injectionPoint, injection.isCancellable(), this.globalEventID, injection.captureLocals(), injection.getLocalTypes());
        injection.addEventsToHandler(handler);
        ++this.globalEventID;
    }

    public static void dumpInjectionState() {
        int uninjectedCount = 0;
        int eventCount = 0;
        LiteLoaderLogger.debug("EventInjectionTransformer: Injection State", new Object[0]);
        LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
        for (Map.Entry<String, Map<String, Map<Event, InjectionPoint>>> mapping : eventMappings.entrySet()) {
            LiteLoaderLogger.debug("Class: %s", mapping.getKey());
            for (Map.Entry<String, Map<Event, InjectionPoint>> classMapping : mapping.getValue().entrySet()) {
                LiteLoaderLogger.debug("    Method: %s", classMapping.getKey());
                for (Event event : classMapping.getValue().keySet()) {
                    uninjectedCount += event.dumpInjectionState();
                    ++eventCount;
                }
            }
        }
        LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
        LiteLoaderLogger.debug("Listed %d injection candidates with %d uninjected", eventCount, uninjectedCount);
        LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
    }

    static class Injection {
        private final AbstractInsnNode node;
        private final boolean captureLocals;
        private final Set<Event> events = new TreeSet<Event>();
        private boolean hasLocals = false;
        private LocalVariableNode[] locals;

        public Injection(AbstractInsnNode node, boolean captureLocals) {
            this.node = node;
            this.captureLocals = captureLocals;
        }

        public AbstractInsnNode getNode() {
            return this.node;
        }

        public Set<Event> getEvents() {
            return this.events;
        }

        public LocalVariableNode[] getLocals() {
            return this.locals;
        }

        public Type[] getLocalTypes() {
            if (this.locals == null) {
                return null;
            }
            Type[] localTypes = new Type[this.locals.length];
            for (int l2 = 0; l2 < this.locals.length; ++l2) {
                if (this.locals[l2] == null) continue;
                localTypes[l2] = Type.getType((String)this.locals[l2].desc);
            }
            return localTypes;
        }

        public boolean hasLocals() {
            return this.hasLocals;
        }

        public void setLocals(LocalVariableNode[] locals) {
            this.hasLocals = true;
            if (locals == null) {
                return;
            }
            this.locals = locals;
        }

        public boolean captureLocals() {
            return this.captureLocals;
        }

        public void checkCaptureLocals(InjectionPoint injectionPoint) {
            if (injectionPoint.captureLocals != this.captureLocals) {
                throw new RuntimeException("Overlapping injection points defined with incompatible settings. Attempting to handle " + injectionPoint + " with capture locals [" + injectionPoint.captureLocals + "] but already defined injection point with [" + this.captureLocals + "]");
            }
        }

        public void add(Event event) {
            this.events.add(event);
        }

        public int size() {
            return this.events.size();
        }

        public Event getHead() {
            return this.events.iterator().next();
        }

        public void addEventsToHandler(MethodNode handler) {
            for (Event event : this.events) {
                event.addToHandler(handler);
            }
        }

        public boolean isCancellable() {
            boolean cancellable = false;
            for (Event event : this.events) {
                cancellable |= event.isCancellable();
            }
            return cancellable;
        }
    }
}

