/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.permissions;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.Permissible;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.core.ClientPluginChannels;
import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.permissions.LocalPermissions;
import com.mumfrey.liteloader.permissions.PermissibleAllMods;
import com.mumfrey.liteloader.permissions.Permissions;
import com.mumfrey.liteloader.permissions.PermissionsManager;
import com.mumfrey.liteloader.permissions.ServerPermissions;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.eq2online.permissions.ReplicatedPermissionsContainer;

public final class PermissionsManagerClient
implements PermissionsManager,
PluginChannelListener {
    private static PermissionsManagerClient instance;
    private static Permissible allMods;
    private GameEngine<?, ?> engine;
    private Map<String, Permissible> registeredClientMods = new HashMap<String, Permissible>();
    private Map<Permissible, TreeSet<String>> registeredClientPermissions = new HashMap<Permissible, TreeSet<String>>();
    private Set<Permissible> permissibles = new HashSet<Permissible>();
    private LocalPermissions localPermissions = new LocalPermissions();
    private Map<String, ServerPermissions> serverPermissions = new HashMap<String, ServerPermissions>();
    private long lastTickTime = System.currentTimeMillis();
    private int pendingRefreshTicks = 0;
    private int menuTicks = 0;

    public static PermissionsManagerClient getInstance() {
        if (instance == null) {
            instance = new PermissionsManagerClient();
        }
        return instance;
    }

    private PermissionsManagerClient() {
        this.registerClientMod("all", allMods);
    }

    @Override
    public Permissions getPermissions(Permissible mod) {
        String modName;
        ServerPermissions modPermissions;
        if (mod == null) {
            mod = allMods;
        }
        return (modPermissions = this.serverPermissions.get(modName = mod.getPermissibleModName())) != null ? modPermissions : this.localPermissions;
    }

    @Override
    public Long getPermissionUpdateTime(Permissible mod) {
        String modName;
        ServerPermissions modPermissions;
        if (mod == null) {
            mod = allMods;
        }
        return (modPermissions = this.serverPermissions.get(modName = mod.getPermissibleModName())) != null ? modPermissions.getReplicationTime() : 0L;
    }

    public void registerMod(LiteMod mod) {
        if (mod instanceof Permissible) {
            this.registerPermissible((Permissible)mod);
        }
    }

    @Override
    public void registerPermissible(Permissible permissible) {
        if (!this.permissibles.contains(permissible) && permissible.getPermissibleModName() != null) {
            this.registerClientMod(permissible.getPermissibleModName(), permissible);
            permissible.registerPermissions(this);
        }
        this.permissibles.add(permissible);
    }

    private void registerClientMod(String modName, Permissible mod) {
        if (this.registeredClientMods.containsKey(modName)) {
            throw new IllegalArgumentException("Cannot register mod \"" + modName + "\"! The mod was already registered with the permissions manager.");
        }
        this.registeredClientMods.put(modName, mod);
        this.registeredClientPermissions.put(mod, new TreeSet());
    }

    public void onJoinGame(ep netHandler, gt joinGamePacket) {
        this.clearServerPermissions();
        this.scheduleRefresh();
    }

    public void scheduleRefresh() {
        this.pendingRefreshTicks = 2;
    }

    protected void clearServerPermissions() {
        this.serverPermissions.clear();
        for (Permissible permissible : this.permissibles) {
            permissible.onPermissionsCleared(this);
        }
    }

    protected void sendPermissionQueries() {
        for (Permissible mod : this.registeredClientMods.values()) {
            this.sendPermissionQuery(mod);
        }
    }

    public void sendPermissionQuery(Permissible mod) {
        String modName = mod.getPermissibleModName();
        if (this.engine != null && this.engine.isClient() && this.engine.isInGame()) {
            if (!this.registeredClientMods.containsValue(mod)) {
                throw new IllegalArgumentException("The specified mod \"" + modName + "\" was not registered with the permissions system");
            }
            Float modVersion = Float.valueOf(mod.getPermissibleModVersion());
            Set modPermissions = this.registeredClientPermissions.get(mod);
            if (modPermissions != null) {
                ReplicatedPermissionsContainer query = new ReplicatedPermissionsContainer(modName, modVersion, modPermissions);
                if (!query.modName.equals("all") || query.permissions.size() > 0) {
                    byte[] data = query.getBytes();
                    em buffer = new em(Unpooled.buffer());
                    buffer.writeBytes(data);
                    ClientPluginChannels.sendMessage("PERMISSIONSREPL", buffer, PluginChannels.ChannelPolicy.DISPATCH_ALWAYS);
                }
            }
        } else {
            this.serverPermissions.remove(modName);
        }
    }

    @Override
    public void onTick(GameEngine<?, ?> engine, float partialTicks, boolean inGame) {
        this.engine = engine;
        this.lastTickTime = System.currentTimeMillis();
        if (this.pendingRefreshTicks > 0) {
            --this.pendingRefreshTicks;
            if (this.pendingRefreshTicks == 0 && inGame) {
                this.sendPermissionQueries();
                return;
            }
        }
        for (Map.Entry<String, ServerPermissions> modPermissions : this.serverPermissions.entrySet()) {
            if (modPermissions.getValue().isValid()) continue;
            modPermissions.getValue().notifyRefreshPending();
            this.sendPermissionQuery(this.registeredClientMods.get(modPermissions.getKey()));
        }
        this.menuTicks = inGame ? 0 : ++this.menuTicks;
        if (this.menuTicks == 200) {
            this.clearServerPermissions();
        }
    }

    @Override
    public void tamperCheck() {
        if (System.currentTimeMillis() - this.lastTickTime > 60000L) {
            throw new IllegalStateException("Client permissions manager was not ticked for 60 seconds, tamper.");
        }
    }

    @Override
    public void onCustomPayload(String channel, em data) {
        if (channel.equals("PERMISSIONSREPL") && !this.engine.isSinglePlayer()) {
            ServerPermissions modPermissions = null;
            try {
                modPermissions = new ServerPermissions(data);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (modPermissions != null && modPermissions.getModName() != null) {
                this.serverPermissions.put(modPermissions.getModName(), modPermissions);
                Permissible permissible = this.registeredClientMods.get(modPermissions.getModName());
                if (permissible != null) {
                    permissible.onPermissionsChanged(this);
                }
            }
        }
    }

    @Override
    public List<String> getChannels() {
        return Arrays.asList("PERMISSIONSREPL");
    }

    public void registerPermission(String permission) {
        this.registerModPermission(allMods, permission);
    }

    public void registerModPermission(Permissible mod, String permission) {
        if (mod == null) {
            mod = allMods;
        }
        String modName = mod.getPermissibleModName();
        if (!this.registeredClientMods.containsValue(mod)) {
            throw new IllegalArgumentException("Cannot register a mod permission for mod \"" + modName + "\"! The mod was not registered with the permissions manager.");
        }
        permission = PermissionsManagerClient.formatModPermission(modName, permission);
        Set modPermissions = this.registeredClientPermissions.get(mod);
        if (modPermissions != null && !modPermissions.contains(permission)) {
            modPermissions.add(permission);
        }
    }

    public boolean getPermission(String permission) {
        return this.getModPermission(allMods, permission);
    }

    public boolean getPermission(String permission, boolean defaultValue) {
        return this.getModPermission(allMods, permission, defaultValue);
    }

    public boolean getModPermission(Permissible mod, String permission) {
        if (mod == null) {
            mod = allMods;
        }
        permission = PermissionsManagerClient.formatModPermission(mod.getPermissibleModName(), permission);
        Permissions permissions = this.getPermissions(mod);
        if (permissions != null) {
            return permissions.getHasPermission(permission);
        }
        return true;
    }

    public boolean getModPermission(String modName, String permission) {
        Permissible mod = this.registeredClientMods.get(modName);
        return mod != null ? this.getModPermission(mod, permission) : false;
    }

    public boolean getModPermission(Permissible mod, String permission, boolean defaultValue) {
        if (mod == null) {
            mod = allMods;
        }
        permission = PermissionsManagerClient.formatModPermission(mod.getPermissibleModName(), permission);
        Permissions permissions = this.getPermissions(mod);
        if (permissions != null && permissions.getPermissionSet(permission)) {
            return permissions.getHasPermission(permission);
        }
        return defaultValue;
    }

    public boolean getModPermission(String modName, String permission, boolean defaultValue) {
        Permissible mod = this.registeredClientMods.get(modName);
        return mod != null ? this.getModPermission(mod, permission, defaultValue) : defaultValue;
    }

    protected static String formatModPermission(String modName, String permission) {
        return String.format("mod.%s.%s", modName, permission);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public void init(File configPath) {
    }

    @Override
    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    static {
        allMods = new PermissibleAllMods();
    }
}

