/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.exceptions.UnregisteredChannelException;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.permissions.PermissionsManagerServer;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.LinkedList;

public class ServerPluginChannels
extends PluginChannels<ServerPluginChannelListener> {
    private static ServerPluginChannels instance;

    public ServerPluginChannels() {
        if (instance != null) {
            InstantiationException inner = new InstantiationException("Only a single instance of ServerPluginChannels is allowed");
            throw new RuntimeException("Plugin Channels Startup Error", inner);
        }
        instance = this;
    }

    @Override
    protected FastIterableDeque<ServerPluginChannelListener> createHandlerList() {
        return new HandlerList<ServerPluginChannelListener>(ServerPluginChannelListener.class);
    }

    public static ServerPluginChannels getInstance() {
        return instance;
    }

    @Override
    public void initProvider() {
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(ServerPluginChannelListener.class);
    }

    void addServerPluginChannelListener(ServerPluginChannelListener pluginChannelListener) {
        super.addPluginChannelListener(pluginChannelListener);
    }

    void onServerStartup() {
        this.clearPluginChannels(null);
        for (ServerPluginChannelListener pluginChannelListener : this.pluginChannelListeners) {
            this.addPluginChannelsFor(pluginChannelListener);
        }
    }

    void onPlayerJoined(lf player) {
        this.sendRegisteredPluginChannels(player);
    }

    public void onPluginChannelMessage(ep netHandler, im customPayload) {
        if (customPayload != null && customPayload.a() != null) {
            String channel = customPayload.a();
            em data = customPayload.b();
            lf sender = ((lm)netHandler).b;
            this.onPluginChannelMessage(sender, channel, data);
        }
    }

    private final void onPluginChannelMessage(lf sender, String channel, em data) {
        if ("REGISTER".equals(channel)) {
            this.onRegisterPacketReceived(data);
        } else if (this.pluginChannels.containsKey(channel)) {
            try {
                PermissionsManagerServer permissionsManager = LiteLoader.getServerPermissionsManager();
                if (permissionsManager != null) {
                    permissionsManager.onCustomPayload(sender, channel, data);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.onModPacketReceived(sender, channel, data);
        }
    }

    protected void onModPacketReceived(lf sender, String channel, em data) {
        for (ServerPluginChannelListener pluginChannelListener : (LinkedList)this.pluginChannels.get(channel)) {
            try {
                pluginChannelListener.onCustomPayload(sender, channel, data);
                throw new RuntimeException();
            }
            catch (Exception ex) {
                int failCount = 1;
                if (this.faultingPluginChannelListeners.containsKey(pluginChannelListener)) {
                    failCount = (Integer)this.faultingPluginChannelListeners.get(pluginChannelListener) + 1;
                }
                if (failCount >= 1000) {
                    LiteLoaderLogger.warning("Plugin channel listener %s exceeded fault threshold on channel %s with %s", pluginChannelListener.getName(), channel, ex.getClass().getSimpleName());
                    this.faultingPluginChannelListeners.remove(pluginChannelListener);
                    continue;
                }
                this.faultingPluginChannelListeners.put(pluginChannelListener, failCount);
            }
        }
    }

    protected void sendRegisteredPluginChannels(lf player) {
        try {
            em registrationData = this.getRegistrationData();
            if (registrationData != null) {
                this.sendRegistrationData(player, registrationData);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning(ex, "Error dispatching REGISTER packet to client %s", player.f_());
        }
    }

    private void sendRegistrationData(lf recipient, em registrationData) {
        ServerPluginChannels.dispatch(recipient, new gg("REGISTER", registrationData));
    }

    public static boolean sendMessage(lf recipient, String channel, em data, PluginChannels.ChannelPolicy policy) {
        if (instance != null) {
            return instance.send(recipient, channel, data, policy);
        }
        return false;
    }

    private boolean send(lf recipient, String channel, em data, PluginChannels.ChannelPolicy policy) {
        if (recipient == null) {
            return false;
        }
        if (channel == null || channel.length() > 16 || "REGISTER".equals(channel) || "UNREGISTER".equals(channel)) {
            throw new RuntimeException("Invalid channel name specified");
        }
        if (!policy.allows(this, channel)) {
            if (policy.isSilent()) {
                return false;
            }
            throw new UnregisteredChannelException(channel);
        }
        gg payload = new gg(channel, data);
        return ServerPluginChannels.dispatch(recipient, payload);
    }

    static boolean dispatch(lf recipient, gg payload) {
        try {
            if (recipient != null && recipient.a != null) {
                recipient.a.a((ff)payload);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

