/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.google.common.base.Charsets;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.core.CommonPluginChannelListener;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PluginChannels<L extends CommonPluginChannelListener>
implements InterfaceProvider {
    protected static final String CHANNEL_REGISTER = "REGISTER";
    protected static final String CHANNEL_UNREGISTER = "UNREGISTER";
    protected static final int WARN_FAULT_THRESHOLD = 1000;
    protected final HashMap<String, LinkedList<L>> pluginChannels = new HashMap();
    protected final FastIterableDeque<L> pluginChannelListeners;
    protected final Set<String> remotePluginChannels = new HashSet<String>();
    protected final Map<L, Integer> faultingPluginChannelListeners = new HashMap<L, Integer>();

    PluginChannels() {
        this.pluginChannelListeners = this.createHandlerList();
    }

    protected abstract FastIterableDeque<L> createHandlerList();

    public Set<String> getLocalChannels() {
        return Collections.unmodifiableSet(this.pluginChannels.keySet());
    }

    public Set<String> getRemoteChannels() {
        return Collections.unmodifiableSet(this.remotePluginChannels);
    }

    public boolean isRemoteChannelRegistered(String channel) {
        return this.remotePluginChannels.contains(channel);
    }

    protected void addPluginChannelListener(L pluginChannelListener) {
        this.pluginChannelListeners.add(pluginChannelListener);
    }

    protected void clearPluginChannels(ep netHandler) {
        this.pluginChannels.clear();
        this.remotePluginChannels.clear();
        this.faultingPluginChannelListeners.clear();
    }

    protected void onRegisterPacketReceived(em data) {
        try {
            byte[] bytes = new byte[data.readableBytes()];
            data.readBytes(bytes);
            String channels = new String(bytes, Charsets.UTF_8);
            for (String channel : channels.split("\u0000")) {
                this.remotePluginChannels.add(channel);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning(ex, "Error decoding REGISTER packet from remote host %s", ex.getClass().getSimpleName());
        }
    }

    protected em getRegistrationData() {
        if (this.pluginChannels.keySet().size() > 0) {
            StringBuilder channelList = new StringBuilder();
            boolean separator = false;
            for (String channel : this.pluginChannels.keySet()) {
                if (separator) {
                    channelList.append("\u0000");
                }
                channelList.append(channel);
                separator = true;
            }
            em buffer = new em(Unpooled.buffer());
            buffer.writeBytes(channelList.toString().getBytes(Charsets.UTF_8));
            return buffer;
        }
        return null;
    }

    protected void addPluginChannelsFor(L pluginChannelListener) {
        List<String> channels = pluginChannelListener.getChannels();
        if (channels != null) {
            for (String channel : channels) {
                if (channel.length() > 16 || channel.toUpperCase().equals(CHANNEL_REGISTER) || channel.toUpperCase().equals(CHANNEL_UNREGISTER)) continue;
                if (!this.pluginChannels.containsKey(channel)) {
                    this.pluginChannels.put(channel, new LinkedList());
                }
                this.pluginChannels.get(channel).add(pluginChannelListener);
            }
        }
    }

    public static enum ChannelPolicy {
        DISPATCH,
        DISPATCH_IF_REGISTERED,
        DISPATCH_ALWAYS;


        public boolean allows(PluginChannels<?> channels, String channel) {
            if (this == DISPATCH_ALWAYS) {
                return true;
            }
            return channels.isRemoteChannelRegistered(channel);
        }

        public boolean isSilent() {
            return this != DISPATCH_IF_REGISTERED;
        }
    }
}

