/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.PlayerInteractionListener;
import com.mumfrey.liteloader.core.IEventState;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.util.EntityUtilities;
import java.lang.ref.WeakReference;
import net.minecraft.server.MinecraftServer;

public class PlayerEventState
implements IEventState {
    private static long MISS = new cj(-1, -1, -1).g();
    private WeakReference<lf> playerRef;
    private final LiteLoaderEventBroker<?, ?> broker;
    private double traceDistance = 256.0;
    private int suppressLeftTicks;
    private int suppressRightTicks;
    private boolean leftClick;
    private boolean rightClick;
    private auh hit;
    private String locale = "en_US";

    public PlayerEventState(lf player, LiteLoaderEventBroker<?, ?> broker) {
        this.playerRef = new WeakReference<lf>(player);
        this.broker = broker;
    }

    public void setTraceDistance(int renderDistance) {
        this.traceDistance = (double)renderDistance * 16.0;
    }

    public double getTraceDistance() {
        return this.traceDistance;
    }

    public void setLocale(String lang) {
        if (lang.matches("^[a-z]{2}_[A-Z]{2}$")) {
            this.locale = lang;
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public lf getPlayer() {
        return (lf)this.playerRef.get();
    }

    public void onSpawned() {
    }

    @Override
    public void onTick(MinecraftServer server) {
        if (this.leftClick && this.suppressLeftTicks == 0) {
            this.broker.onPlayerClickedAir(this.getPlayer(), PlayerInteractionListener.MouseButton.LEFT, this.hit.a(), this.hit.b, this.hit.a);
        }
        if (this.rightClick && this.suppressRightTicks == 0) {
            this.broker.onPlayerClickedAir(this.getPlayer(), PlayerInteractionListener.MouseButton.RIGHT, this.hit.a(), this.hit.b, this.hit.a);
        }
        if (this.suppressLeftTicks > 0) {
            --this.suppressLeftTicks;
        }
        if (this.suppressRightTicks > 0) {
            --this.suppressRightTicks;
        }
        this.leftClick = false;
        this.rightClick = false;
    }

    public boolean onPlayerInteract(LiteLoaderEventBroker.InteractType action, lf player, cj position, cq side) {
        this.hit = EntityUtilities.rayTraceFromEntity((pk)player, this.traceDistance, 0.0f);
        if (action == LiteLoaderEventBroker.InteractType.LEFT_CLICK) {
            this.leftClick = true;
            return true;
        }
        if (action == LiteLoaderEventBroker.InteractType.RIGHT_CLICK) {
            this.rightClick = true;
            return true;
        }
        if ((action == LiteLoaderEventBroker.InteractType.LEFT_CLICK_BLOCK || action == LiteLoaderEventBroker.InteractType.DIG_BLOCK_MAYBE) && this.suppressLeftTicks == 0) {
            this.suppressLeftTicks += 2;
            return this.broker.onPlayerClickedBlock(player, PlayerInteractionListener.MouseButton.LEFT, position, side);
        }
        if (action == LiteLoaderEventBroker.InteractType.PLACE_BLOCK_MAYBE) {
            if (this.suppressRightTicks > 0) {
                return true;
            }
            if (position.g() == MISS) {
                auh actualHit = EntityUtilities.rayTraceFromEntity((pk)player, player.bA.d ? 5.0 : 4.5, 0.0f);
                if (actualHit.a == auh.a.a) {
                    this.rightClick = true;
                    return true;
                }
            }
            ++this.suppressRightTicks;
            ++this.suppressLeftTicks;
            return this.broker.onPlayerClickedBlock(player, PlayerInteractionListener.MouseButton.RIGHT, position, side);
        }
        return true;
    }
}

