/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.PacketHandler;
import com.mumfrey.liteloader.ServerChatFilter;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.common.transformers.PacketEventInfo;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.runtime.Packets;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.List;

public abstract class PacketEvents
implements InterfaceProvider {
    protected static PacketEvents instance;
    protected final LiteLoader loader;
    private PacketHandlerList[] packetHandlers = new PacketHandlerList[Packets.count()];
    private FastIterable<ServerChatFilter> serverChatFilters = new HandlerList<ServerChatFilter>(ServerChatFilter.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private final int loginSuccessPacketId = Packets.S02PacketLoginSuccess.getIndex();
    private final int serverChatPacketId = Packets.S02PacketChat.getIndex();
    private final int clientChatPacketId = Packets.C01PacketChatMessage.getIndex();
    private final int joinGamePacketId = Packets.S01PacketJoinGame.getIndex();
    private final int serverPayloadPacketId = Packets.S3FPacketCustomPayload.getIndex();
    private final int clientPayloadPacketId = Packets.C17PacketCustomPayload.getIndex();
    private final int clientSettingsPacketId = Packets.C15PacketClientSettings.getIndex();

    public PacketEvents() {
        instance = this;
        this.loader = LiteLoader.getInstance();
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(PacketHandler.class);
        delegate.registerInterface(ServerChatFilter.class);
    }

    @Override
    public void initProvider() {
    }

    public void registerServerChatFilter(ServerChatFilter serverChatFilter) {
        this.serverChatFilters.add(serverChatFilter);
    }

    public void registerPacketHandler(PacketHandler handler) {
        List<Class<ff<?>>> handledPackets = handler.getHandledPackets();
        if (handledPackets != null) {
            for (Class<ff<?>> packetClass : handledPackets) {
                String packetClassName = packetClass.getName();
                int packetId = Packets.indexOf(packetClassName);
                if (packetId == -1 || packetId >= this.packetHandlers.length) {
                    LiteLoaderLogger.warning("PacketHandler %s attempted to register a handler for unupported packet class %s", handler.getName(), packetClassName);
                    continue;
                }
                if (this.packetHandlers[packetId] == null) {
                    this.packetHandlers[packetId] = new PacketHandlerList();
                }
                this.packetHandlers[packetId].add(handler);
            }
        }
    }

    public static void handlePacket(PacketEventInfo<ff<?>> e, ep netHandler) {
        instance.handlePacket(e, netHandler, e.getPacketId());
    }

    private void handlePacket(PacketEventInfo<ff<?>> e, ep netHandler, int packetId) {
        Packets packetInfo = Packets.packets[e.getPacketId()];
        od threadListener = this.getPacketContextListener(packetInfo.getContext());
        if (threadListener != null && !threadListener.aJ()) {
            this.handleAsyncPacketEvent(e, netHandler, packetId);
            return;
        }
        if (this.handlePacketEvent(e, netHandler, packetId) || this.packetHandlers[packetId] == null || e.isCancelled()) {
            return;
        }
        if (((PacketHandler)this.packetHandlers[packetId].all()).handlePacket(netHandler, (ff)e.getSource())) {
            return;
        }
        e.cancel();
    }

    protected abstract od getPacketContextListener(Packets.Context var1);

    protected void handleAsyncPacketEvent(PacketEventInfo<ff<?>> e, ep netHandler, int packetId) {
        ff packet = (ff)e.getSource();
        if (packetId == this.loginSuccessPacketId) {
            this.handlePacket(e, netHandler, (jg)packet);
        }
    }

    protected boolean handlePacketEvent(PacketEventInfo<ff<?>> e, ep netHandler, int packetId) {
        ff packet = (ff)e.getSource();
        if (packetId == this.serverChatPacketId) {
            this.handlePacket(e, netHandler, (fy)packet);
            return true;
        }
        if (packetId == this.clientChatPacketId) {
            this.handlePacket(e, netHandler, (ie)packet);
            return true;
        }
        if (packetId == this.joinGamePacketId) {
            this.handlePacket(e, netHandler, (gt)packet);
            return true;
        }
        if (packetId == this.serverPayloadPacketId) {
            this.handlePacket(e, netHandler, (gg)packet);
            return true;
        }
        if (packetId == this.clientPayloadPacketId) {
            this.handlePacket(e, netHandler, (im)packet);
            return true;
        }
        if (packetId == this.clientSettingsPacketId) {
            this.handlePacket(e, netHandler, (ih)packet);
            return true;
        }
        return false;
    }

    protected abstract void handlePacket(PacketEventInfo<ff<?>> var1, ep var2, jg var3);

    protected abstract void handlePacket(PacketEventInfo<ff<?>> var1, ep var2, fy var3);

    protected void handlePacket(PacketEventInfo<ff<?>> e, ep netHandler, ie packet) {
        lf player;
        lf lf2 = player = netHandler instanceof lm ? ((lm)netHandler).b : null;
        if (!this.serverChatFilters.all().onChat(player, packet, packet.a())) {
            e.cancel();
        }
    }

    protected void handlePacket(PacketEventInfo<ff<?>> e, ep netHandler, gt packet) {
        this.loader.onJoinGame(netHandler, packet);
    }

    protected void handlePacket(PacketEventInfo<ff<?>> e, ep netHandler, gg packet) {
        LiteLoader.getClientPluginChannels().onPluginChannelMessage(packet);
    }

    protected void handlePacket(PacketEventInfo<ff<?>> e, ep netHandler, im packet) {
        LiteLoader.getServerPluginChannels().onPluginChannelMessage(netHandler, packet);
    }

    private void handlePacket(PacketEventInfo<ff<?>> e, ep netHandler, ih packet) {
        if (netHandler instanceof lm) {
            LiteLoaderEventBroker.broker.onPlayerSettingsReceived(((lm)netHandler).b, packet);
        }
    }

    class PacketHandlerList
    extends HandlerList<PacketHandler> {
        private static final long serialVersionUID = 1L;

        PacketHandlerList() {
            super(PacketHandler.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
        }
    }
}

