/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.PlayerInteractionListener;
import com.mumfrey.liteloader.PlayerMoveListener;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.ServerCommandProvider;
import com.mumfrey.liteloader.ServerPlayerListener;
import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.ServerTickable;
import com.mumfrey.liteloader.ShutdownListener;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.api.ShutdownObserver;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.common.ducks.IPacketClientSettings;
import com.mumfrey.liteloader.core.CommonPluginChannelListener;
import com.mumfrey.liteloader.core.IEventState;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.PlayerEventState;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.Position;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public abstract class LiteLoaderEventBroker<TClient, TServer extends MinecraftServer>
implements InterfaceProvider,
ShutdownObserver {
    static LiteLoaderEventBroker<?, ?> broker;
    protected final LiteLoader loader;
    protected final GameEngine<TClient, TServer> engine;
    protected final nt profiler;
    protected LiteLoaderMods mods;
    private Map<UUID, PlayerEventState> playerStates = new HashMap<UUID, PlayerEventState>();
    private FastIterableDeque<IEventState> playerStateList = new HandlerList<IEventState>(IEventState.class);
    private FastIterable<ServerCommandProvider> serverCommandProviders = new HandlerList<ServerCommandProvider>(ServerCommandProvider.class);
    private FastIterable<ServerPlayerListener> serverPlayerListeners = new HandlerList<ServerPlayerListener>(ServerPlayerListener.class);
    private FastIterable<PlayerInteractionListener> playerInteractionListeners = new HandlerList<PlayerInteractionListener>(PlayerInteractionListener.class, HandlerList.ReturnLogicOp.AND);
    private FastIterable<PlayerMoveListener> playerMoveListeners = new HandlerList<PlayerMoveListener>(PlayerMoveListener.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private FastIterable<ServerTickable> serverTickListeners = new HandlerList<ServerTickable>(ServerTickable.class);
    private FastIterable<ShutdownListener> shutdownListeners = new HandlerList<ShutdownListener>(ShutdownListener.class);

    public LiteLoaderEventBroker(LiteLoader loader, GameEngine<TClient, TServer> engine, LoaderProperties properties) {
        this.loader = loader;
        this.engine = engine;
        this.profiler = engine.getProfiler();
        broker = this;
    }

    void setMods(LiteLoaderMods mods) {
        this.mods = mods;
    }

    protected void onStartupComplete() {
        LoadingProgress.setMessage("Checking mods...");
        this.mods.onStartupComplete();
        LoadingProgress.setMessage("Initialising CoreProviders...");
        this.loader.onStartupComplete();
        LoadingProgress.setMessage("Starting Game...");
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return LiteMod.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(ServerCommandProvider.class);
        delegate.registerInterface(ServerPlayerListener.class);
        delegate.registerInterface(PlayerInteractionListener.class);
        delegate.registerInterface(PlayerMoveListener.class);
        delegate.registerInterface(CommonPluginChannelListener.class);
        delegate.registerInterface(ServerTickable.class);
        delegate.registerInterface(ShutdownListener.class);
    }

    public void addCommonPluginChannelListener(CommonPluginChannelListener listener) {
        if (!(listener instanceof PluginChannelListener) && !(listener instanceof ServerPluginChannelListener)) {
            LiteLoaderLogger.warning("Interface error for mod '%1s'. Implementing CommonPluginChannelListener has no effect! Use PluginChannelListener or ServerPluginChannelListener instead", listener.getName());
        }
    }

    public void addServerCommandProvider(ServerCommandProvider serverCommandProvider) {
        this.serverCommandProviders.add(serverCommandProvider);
    }

    public void addServerPlayerListener(ServerPlayerListener serverPlayerListener) {
        this.serverPlayerListeners.add(serverPlayerListener);
    }

    public void addPlayerInteractionListener(PlayerInteractionListener playerInteractionListener) {
        this.playerInteractionListeners.add(playerInteractionListener);
    }

    public void addPlayerMoveListener(PlayerMoveListener playerMoveListener) {
        this.playerMoveListeners.add(playerMoveListener);
    }

    public void addServerTickable(ServerTickable serverTickable) {
        this.serverTickListeners.add(serverTickable);
    }

    public void addShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownListeners.add(shutdownListener);
    }

    public void onStartServer(MinecraftServer instance, String folderName, String worldName, adp worldSettings) {
        l commandManager = instance.P();
        if (commandManager instanceof bd) {
            bd serverCommandManager = (bd)commandManager;
            this.serverCommandProviders.all().provideCommands(serverCommandManager);
        }
        LiteLoader.getServerPluginChannels().onServerStartup();
        this.playerStates.clear();
    }

    public void onSpawnPlayer(lx scm, lf player, GameProfile profile) {
        this.serverPlayerListeners.all().onPlayerConnect(player, profile);
        PlayerEventState playerState = this.getPlayerState(player);
        playerState.onSpawned();
    }

    public void onPlayerLogin(lx scm, lf player) {
        LiteLoader.getServerPluginChannels().onPlayerJoined(player);
    }

    public void onInitializePlayerConnection(lx scm, ek netManager, lf player) {
        this.serverPlayerListeners.all().onPlayerLoggedIn(player);
    }

    public void onRespawnPlayer(lx scm, lf player, lf oldPlayer, int dimension, boolean won) {
        this.serverPlayerListeners.all().onPlayerRespawn(player, oldPlayer, dimension, won);
    }

    public void onPlayerLogout(lx scm, lf player) {
        this.serverPlayerListeners.all().onPlayerLogout(player);
        this.removePlayer(player);
    }

    protected void onTick(boolean clock, float partialTicks, boolean inGame) {
        this.loader.onTick(clock, partialTicks, inGame);
    }

    protected void onPostRender(int mouseX, int mouseY, float partialTicks) {
        this.loader.onPostRender(mouseX, mouseY, partialTicks);
    }

    protected void onWorldChanged(adm world) {
        this.loader.onWorldChanged(world);
    }

    public void onServerTick(MinecraftServer server) {
        ((IEventState)this.playerStateList.all()).onTick(server);
        this.serverTickListeners.all().onTick(server);
    }

    public boolean onPlaceBlock(lm netHandler, lf playerMP, cj pos, cq facing) {
        if (!this.onPlayerInteract(InteractType.PLACE_BLOCK_MAYBE, playerMP, pos, facing)) {
            fv cancellation = new fv(playerMP.o, pos.a(facing));
            netHandler.b.a.a((ff)cancellation);
            playerMP.a(playerMP.bj);
            return false;
        }
        return true;
    }

    public boolean onClickedAir(lm netHandler) {
        return this.onPlayerInteract(InteractType.LEFT_CLICK, netHandler.b, null, cq.d);
    }

    public boolean onPlayerDigging(lm netHandler, cj pos, lf playerMP) {
        if (!this.onPlayerInteract(InteractType.DIG_BLOCK_MAYBE, playerMP, pos, cq.d)) {
            fv cancellation = new fv(playerMP.o, pos);
            netHandler.b.a.a((ff)cancellation);
            return false;
        }
        return true;
    }

    public boolean onUseItem(cj pos, cq side, lf playerMP) {
        if (!this.onPlayerInteract(InteractType.PLACE_BLOCK_MAYBE, playerMP, pos, side)) {
            fv cancellation = new fv(playerMP.o, pos);
            playerMP.a.a((ff)cancellation);
            return false;
        }
        return true;
    }

    public boolean onBlockClicked(cj pos, cq side, lg manager) {
        if (!this.onPlayerInteract(InteractType.LEFT_CLICK_BLOCK, manager.b, pos, side)) {
            fv cancellation = new fv(manager.a, pos);
            manager.b.a.a((ff)cancellation);
            return false;
        }
        return true;
    }

    public boolean onPlayerInteract(InteractType action, lf player, cj position, cq side) {
        PlayerEventState eventState = this.getPlayerState(player);
        return eventState.onPlayerInteract(action, player, position, side);
    }

    void onPlayerClickedAir(lf player, PlayerInteractionListener.MouseButton button, cj tracePos, cq traceSideHit, auh.a traceHitType) {
        this.playerInteractionListeners.all().onPlayerClickedAir(player, button, tracePos, traceSideHit, traceHitType);
    }

    boolean onPlayerClickedBlock(lf player, PlayerInteractionListener.MouseButton button, cj hitPos, cq sideHit) {
        return this.playerInteractionListeners.all().onPlayerClickedBlock(player, button, hitPos, sideHit);
    }

    public boolean onPlayerMove(lm netHandler, ip packet, lf playerMP, le world) {
        Position from = new Position((pk)playerMP, true);
        double toX = playerMP.s;
        double toY = playerMP.t;
        double toZ = playerMP.u;
        float toYaw = playerMP.y;
        float toPitch = playerMP.z;
        if (packet.g()) {
            toX = packet.a();
            toY = packet.b();
            toZ = packet.c();
        }
        if (packet.h()) {
            toYaw = packet.d();
            toPitch = packet.e();
        }
        Position to = new Position(toX, toY, toZ, toYaw, toPitch);
        ReturnValue<Position> pos = new ReturnValue<Position>(to);
        if (!this.playerMoveListeners.all().onPlayerMove(playerMP, from, to, pos)) {
            playerMP.a(from.a, from.b, from.c, playerMP.A, playerMP.B);
            playerMP.a.a((ff)new fi(from.a, from.b, from.c, playerMP.A, playerMP.B, Collections.emptySet()));
            return false;
        }
        if (pos.isSet()) {
            Position newPos = pos.get();
            netHandler.a(newPos.a, newPos.b, newPos.c, newPos.yaw, newPos.pitch);
            return false;
        }
        return true;
    }

    void onPlayerSettingsReceived(lf player, ih packet) {
        PlayerEventState playerState = this.getPlayerState(player);
        playerState.setTraceDistance(((IPacketClientSettings)packet).getViewDistance());
        playerState.setLocale(packet.a());
    }

    public PlayerEventState getPlayerState(lf player) {
        PlayerEventState playerState = this.playerStates.get(player.aK());
        if (playerState == null) {
            playerState = new PlayerEventState(player, this);
            this.playerStates.put(player.aK(), playerState);
            this.playerStateList.add(playerState);
        }
        return playerState;
    }

    protected void removePlayer(lf player) {
        PlayerEventState playerState = this.playerStates.remove(player.aK());
        if (playerState != null) {
            this.playerStateList.remove(playerState);
        }
    }

    @Override
    public void onShutDown() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.onShutDown();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static enum InteractType {
        RIGHT_CLICK,
        LEFT_CLICK,
        LEFT_CLICK_BLOCK,
        PLACE_BLOCK_MAYBE,
        DIG_BLOCK_MAYBE;

    }

    public static class ReturnValue<T> {
        private T value;
        private boolean isSet;

        public ReturnValue(T value) {
            this.value = value;
        }

        public ReturnValue() {
        }

        public boolean isSet() {
            return this.isSet;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.isSet = true;
            this.value = value;
        }
    }
}

