/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui.startup;

import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.gl.GL;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.Display;

public class LoadingBar
extends LoadingProgress {
    private static LoadingBar instance;
    private static final String LOADING_MESSAGE_1 = "Starting Game...";
    private static final String LOADING_MESSAGE_2 = "Initialising...";
    private int minecraftProgress = 0;
    private int totalMinecraftProgress = 606;
    private int liteLoaderProgressScale = 3;
    private int liteLoaderProgress = 0;
    private int totalLiteLoaderProgress = 0;
    private jy textureLocation = new jy("textures/gui/title/mojang.png");
    private String minecraftMessage = "Starting Game...";
    private String message = "";
    private ave minecraft;
    private bmj textureManager;
    private avn fontRenderer;
    private bfw fbo;
    private boolean enabled = true;
    private boolean errored;
    private boolean calculatedColour = false;
    private int barLuma = 0;
    private int r2 = 246;
    private int g2 = 136;
    private int b2 = 62;
    private int logIndex = 0;
    private List<String> logTail = new ArrayList<String>();

    public LoadingBar() {
        instance = this;
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    protected void _dispose() {
        this.minecraft = null;
        this.textureManager = null;
        this.fontRenderer = null;
        this.disposeFbo();
    }

    private void disposeFbo() {
        if (this.fbo != null) {
            this.fbo.a();
            this.fbo = null;
        }
    }

    public static void incrementProgress() {
        if (instance != null) {
            instance._incrementProgress();
        }
    }

    protected void _incrementProgress() {
        this.message = this.minecraftMessage;
        ++this.minecraftProgress;
        this.render();
    }

    public static void initTextures() {
        if (instance != null) {
            instance._initTextures();
        }
    }

    protected void _initTextures() {
        this.minecraftMessage = LOADING_MESSAGE_2;
    }

    @Override
    protected void _incLiteLoaderProgress() {
        this.liteLoaderProgress += this.liteLoaderProgressScale;
        this.render();
    }

    @Override
    protected void _setMessage(String message) {
        this.message = message;
        this.render();
    }

    @Override
    protected void _incLiteLoaderProgress(String message) {
        this.message = message;
        this.liteLoaderProgress += this.liteLoaderProgressScale;
        this.render();
    }

    @Override
    protected void _incTotalLiteLoaderProgress(int by) {
        this.totalLiteLoaderProgress += by * this.liteLoaderProgressScale;
        this.render();
    }

    private void render() {
        if (!this.enabled || this.errored) {
            return;
        }
        try {
            if (this.minecraft == null) {
                this.minecraft = ave.A();
            }
            if (this.textureManager == null) {
                this.textureManager = this.minecraft.P();
            }
            if (Display.isCreated() && this.textureManager != null) {
                if (this.fontRenderer == null) {
                    this.fontRenderer = new avn(this.minecraft.t, new jy("textures/font/ascii.png"), this.textureManager, false);
                    this.fontRenderer.a(this.minecraft.Q());
                }
                double totalProgress = this.totalMinecraftProgress + this.totalLiteLoaderProgress;
                double progress = (double)(this.minecraftProgress + this.liteLoaderProgress) / totalProgress;
                this.render(progress);
            }
        }
        catch (Exception ex) {
            this.errored = true;
        }
    }

    private void render(double progress) {
        if (this.totalMinecraftProgress == -1) {
            this.totalMinecraftProgress = 606 - this.minecraftProgress;
            this.minecraftProgress = 0;
        }
        if (!this.calculatedColour) {
            this.calculatedColour = true;
            bmk texture = this.textureManager.b(this.textureLocation);
            if (texture == null) {
                try {
                    blz textureData = this.loadTexture(this.minecraft.Q(), this.textureLocation);
                    this.textureLocation = this.minecraft.P().a("loadingScreen", textureData);
                    this.findMostCommonColour(textureData.e());
                    textureData.d();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        avr scaledResolution = new avr(this.minecraft);
        int scaleFactor = scaledResolution.e();
        int scaledWidth = scaledResolution.a();
        int scaledHeight = scaledResolution.b();
        int fboWidth = scaledWidth * scaleFactor;
        int fboHeight = scaledHeight * scaleFactor;
        if (this.fbo == null) {
            this.fbo = new bfw(fboWidth, fboHeight, true);
        } else if (this.fbo.c != fboWidth || this.fbo.d != fboHeight) {
            this.fbo.a(fboWidth, fboHeight);
        }
        this.fbo.a(false);
        GL.glMatrixMode(5889);
        GL.glLoadIdentity();
        GL.glOrtho(0.0, scaledWidth, scaledHeight, 0.0, 1000.0, 3000.0);
        GL.glMatrixMode(5888);
        GL.glLoadIdentity();
        GL.glTranslatef(0.0f, 0.0f, -2000.0f);
        GL.glClear(16640);
        GL.glDisableLighting();
        GL.glDisableFog();
        GL.glDisableDepthTest();
        GL.glEnableTexture2D();
        this.textureManager.a(this.textureLocation);
        bfx tessellator = bfx.a();
        bfd worldRenderer = tessellator.c();
        worldRenderer.a(7, bms.e);
        GL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        worldRenderer.b(0.0, (double)scaledHeight, 0.0).d();
        worldRenderer.b((double)scaledWidth, (double)scaledHeight, 0.0).d();
        worldRenderer.b((double)scaledWidth, 0.0, 0.0).d();
        worldRenderer.b(0.0, 0.0, 0.0).d();
        tessellator.b();
        GL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        int left = (scaledWidth - 256) / 2;
        int top = (scaledHeight - 256) / 2;
        int u1 = 0;
        int v1 = 0;
        int u2 = 256;
        int v2 = 256;
        float texMapScale = 0.00390625f;
        worldRenderer.a(7, bms.g);
        worldRenderer.b((double)(left + 0), (double)(top + v2), 0.0).a((double)((float)(u1 + 0) * texMapScale), (double)((float)(v1 + v2) * texMapScale)).d();
        worldRenderer.b((double)(left + u2), (double)(top + v2), 0.0).a((double)((float)(u1 + u2) * texMapScale), (double)((float)(v1 + v2) * texMapScale)).d();
        worldRenderer.b((double)(left + u2), (double)(top + 0), 0.0).a((double)((float)(u1 + u2) * texMapScale), (double)((float)(v1 + 0) * texMapScale)).d();
        worldRenderer.b((double)(left + 0), (double)(top + 0), 0.0).a((double)((float)(u1 + 0) * texMapScale), (double)((float)(v1 + 0) * texMapScale)).d();
        tessellator.b();
        GL.glEnableTexture2D();
        GL.glEnableColorLogic();
        GL.glLogicOp(5387);
        this.fontRenderer.a(this.message, 1, scaledHeight - 19, -16777216);
        if (LiteLoaderLogger.DEBUG) {
            int logBottom = this.minecraft.e - 20 * scaleFactor - 2;
            GL.glPushMatrix();
            GL.glScalef(1.0f / (float)scaleFactor, 1.0f / (float)scaleFactor, 1.0f);
            this.renderLogTail(logBottom);
            GL.glPopMatrix();
        }
        GL.glDisableColorLogic();
        GL.glEnableTexture2D();
        double barHeight = 10.0;
        double barWidth = scaledResolution.c() - 2.0;
        GL.glDisableTexture2D();
        GL.glEnableBlend();
        GL.glEnableAlphaTest();
        GL.glAlphaFunc(516, 0.0f);
        GL.glBlendFunc(770, 771);
        worldRenderer.a(7, bms.e);
        float luma = (float)this.barLuma / 255.0f;
        GL.glColor4f(luma, luma, luma, 0.5f);
        worldRenderer.b(0.0, (double)scaledHeight, 0.0).d();
        worldRenderer.b(0.0 + (double)scaledWidth, (double)scaledHeight, 0.0).d();
        worldRenderer.b(0.0 + (double)scaledWidth, (double)scaledHeight - barHeight, 0.0).d();
        worldRenderer.b(0.0, (double)scaledHeight - barHeight, 0.0).d();
        tessellator.b();
        barHeight -= 1.0;
        worldRenderer.a(7, bms.f);
        float r2 = (float)this.r2 / 255.0f;
        float g2 = (float)this.g2 / 255.0f;
        float b2 = (float)this.b2 / 255.0f;
        worldRenderer.b(1.0 + barWidth * progress, (double)(scaledHeight - 1), 1.0).a(r2, g2, b2, 1.0f).d();
        worldRenderer.b(1.0 + barWidth * progress, (double)scaledHeight - barHeight, 1.0).a(r2, g2, b2, 1.0f).d();
        worldRenderer.b(1.0, (double)scaledHeight - barHeight, 1.0).a(0.0f, 0.0f, 0.0f, 1.0f).d();
        worldRenderer.b(1.0, (double)(scaledHeight - 1), 1.0).a(0.0f, 0.0f, 0.0f, 1.0f).d();
        tessellator.b();
        GL.glAlphaFunc(516, 0.1f);
        GL.glDisableLighting();
        GL.glDisableFog();
        this.fbo.e();
        this.fbo.c(fboWidth, fboHeight);
        GL.glEnableAlphaTest();
        GL.glAlphaFunc(516, 0.1f);
        this.minecraft.h();
    }

    private void renderLogTail(int yPos) {
        if ((long)this.logIndex != LiteLoaderLogger.getLogIndex()) {
            this.logTail = LiteLoaderLogger.getLogTail();
        }
        for (int logIndex = this.logTail.size() - 1; yPos > 10 && logIndex >= 0; --logIndex) {
            this.fontRenderer.a(this.logTail.get(logIndex), 10, yPos -= 10, -16777216);
        }
    }

    private void findMostCommonColour(int[] textureData) {
        int paletteIndex;
        int[] freq = new int[512];
        for (int pos = 0; pos < textureData.length; ++pos) {
            int n = paletteIndex = ((textureData[pos] >> 21 & 7) << 6) + ((textureData[pos] >> 13 & 7) << 3) + (textureData[pos] >> 5 & 7);
            freq[n] = freq[n] + 1;
        }
        int peak = 0;
        for (paletteIndex = 2; paletteIndex < 511; ++paletteIndex) {
            if (freq[paletteIndex] <= peak) continue;
            peak = freq[paletteIndex];
            this.setBarColour(paletteIndex);
        }
    }

    private void setBarColour(int paletteIndex) {
        this.r2 = this.padComponent((paletteIndex & 0x1C0) >> 1);
        this.g2 = this.padComponent((paletteIndex & 0x38) << 2);
        this.b2 = this.padComponent((paletteIndex & 7) << 5);
        this.barLuma = Math.max(this.r2, Math.max(this.g2, this.b2)) < 64 ? 255 : 0;
    }

    private int padComponent(int component) {
        return component > 31 ? component | 0x1F : component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private blz loadTexture(bni resourceManager, jy textureLocation) throws IOException {
        InputStream inputStream = null;
        try {
            bnh resource = resourceManager.a(textureLocation);
            inputStream = resource.b();
            BufferedImage image = ImageIO.read(inputStream);
            blz blz2 = new blz(image);
            return blz2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

