/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui.modlist;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.gui.modlist.GuiModInfoPanel;
import com.mumfrey.liteloader.client.gui.modlist.GuiModListPanel;
import com.mumfrey.liteloader.client.gui.modlist.GuiModListPanelInvalid;
import com.mumfrey.liteloader.client.gui.modlist.ModList;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import java.util.List;
import java.util.Set;

public class ModListEntry {
    private final ModList modList;
    private final LiteLoaderMods mods;
    private final ModInfo<?> modInfo;
    private GuiModListPanel listPanel;
    private GuiModInfoPanel infoPanel;
    private boolean isActive;
    private boolean isValid;
    private boolean isMissingDependencies;
    private boolean isMissingAPIs;
    private boolean isErrored;
    private Set<String> missingDependencies;
    private Set<String> missingAPIs;
    private boolean canBeToggled;
    private boolean willBeEnabled;
    private boolean isExternal;
    private int doubleClickTime = 0;

    ModListEntry(ModList modList, LiteLoaderMods mods, LoaderEnvironment environment, avn fontRenderer, int brandColour, List<ModInfoDecorator> decorators, ModInfo<?> modInfo) {
        this.modList = modList;
        this.mods = mods;
        this.modInfo = modInfo;
        this.isActive = modInfo.isActive();
        this.isValid = modInfo.isValid();
        this.canBeToggled = modInfo.isToggleable() && mods.getEnabledModsList().saveAllowed();
        this.willBeEnabled = mods.isModEnabled(this.modInfo.getIdentifier());
        this.isExternal = modInfo.getContainer().isExternalJar();
        boolean bl = this.isErrored = modInfo.getStartupErrors() != null && modInfo.getStartupErrors().size() > 0;
        if (!modInfo.isActive() && this.isValid) {
            this.isActive = modInfo.getContainer().isEnabled(environment);
            Object modContainer = modInfo.getContainer();
            if (modContainer instanceof LoadableMod) {
                LoadableMod loadableMod = (LoadableMod)modContainer;
                this.missingDependencies = loadableMod.getMissingDependencies();
                this.missingAPIs = loadableMod.getMissingAPIs();
                this.isMissingDependencies = this.missingDependencies.size() > 0;
                this.isMissingAPIs = this.missingAPIs.size() > 0;
            }
        }
        this.initPanels(fontRenderer, brandColour, decorators, modInfo);
    }

    protected void initPanels(avn fontRenderer, int brandColour, List<ModInfoDecorator> decorators, ModInfo<?> modInfo) {
        this.infoPanel = new GuiModInfoPanel(this, fontRenderer, brandColour, modInfo);
        this.listPanel = this.isValid ? new GuiModListPanel(this, fontRenderer, brandColour, modInfo, decorators) : new GuiModListPanelInvalid(this, fontRenderer, brandColour, modInfo, decorators);
    }

    public void onTick() {
        if (this.doubleClickTime > 0) {
            --this.doubleClickTime;
        }
    }

    public void mousePressed(int mouseX, int mouseY, int mouseButton) {
        if (this.getListPanel().isMouseOver()) {
            this.modList.selectMod(this);
            if (this.getListPanel().isMouseOver()) {
                this.getListPanel().mousePressed(mouseX, mouseY, mouseButton);
            }
            if (this.getListPanel().isMouseOverIcon()) {
                this.getListPanel().iconClick((Object)this.modList.getParentScreen());
            } else if (this.doubleClickTime > 0) {
                this.onDoubleClicked();
            }
            this.doubleClickTime = 5;
        }
    }

    protected void onDoubleClicked() {
        this.modList.showConfig(this);
    }

    protected String getTitleText() {
        return this.modInfo.getDisplayName();
    }

    protected String getVersionText() {
        return bnq.a((String)"gui.about.versiontext", (Object[])new Object[]{this.modInfo.getVersion()});
    }

    protected String getStatusText() {
        String statusText;
        String string = statusText = this.isExternal ? bnq.a((String)"gui.status.loaded", (Object[])new Object[0]) : bnq.a((String)"gui.status.active", (Object[])new Object[0]);
        if (this.isMissingAPIs) {
            statusText = "\u00a75" + bnq.a((String)"gui.status.missingapis", (Object[])new Object[0]);
            if (this.canBeToggled && !this.willBeEnabled) {
                statusText = "\u00a7c" + bnq.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        } else if (this.isMissingDependencies) {
            statusText = "\u00a7e" + bnq.a((String)"gui.status.missingdeps", (Object[])new Object[0]);
            if (this.canBeToggled && !this.willBeEnabled) {
                statusText = "\u00a7c" + bnq.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        } else if (this.isErrored) {
            statusText = "\u00a7c" + bnq.a((String)"gui.status.startuperror", (Object[])new Object[0]);
        } else if (this.canBeToggled) {
            if (!this.isActive && !this.willBeEnabled) {
                statusText = "\u00a77" + bnq.a((String)"gui.status.disabled", (Object[])new Object[0]);
            }
            if (!this.isActive && this.willBeEnabled) {
                statusText = "\u00a7a" + bnq.a((String)"gui.status.pending.enabled", (Object[])new Object[0]);
            }
            if (this.isActive && !this.willBeEnabled) {
                statusText = "\u00a7c" + bnq.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        }
        return statusText;
    }

    public void toggleEnabled() {
        if (this.canBeToggled) {
            this.willBeEnabled = !this.willBeEnabled;
            this.mods.setModEnabled(this.modInfo.getIdentifier(), this.willBeEnabled);
        }
    }

    protected void displayHelpMessage(String title, String text) {
        this.infoPanel.displayHelpMessage(title, text);
    }

    public void clearHelpMessage() {
        this.infoPanel.clearHelpMessage();
    }

    public String getKey() {
        return (this.isErrored ? "0000" : "") + this.modInfo.getIdentifier() + Integer.toHexString(this.hashCode());
    }

    public ModInfo<?> getModInfo() {
        return this.modInfo;
    }

    public LiteMod getModInstance() {
        return this.modInfo.getMod();
    }

    public Class<? extends LiteMod> getModClass() {
        return this.modInfo.getModClass();
    }

    public String getName() {
        return this.modInfo.getDisplayName();
    }

    public String getVersion() {
        return this.modInfo.getVersion();
    }

    public String getAuthor() {
        return this.modInfo.getAuthor();
    }

    public String getDescription() {
        return this.modInfo.getDescription();
    }

    public boolean isEnabled() {
        return this.isActive;
    }

    public boolean canBeToggled() {
        return this.canBeToggled;
    }

    public boolean willBeEnabled() {
        return this.willBeEnabled;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isErrored() {
        return this.isErrored;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isMissingAPIs() {
        return this.isMissingAPIs;
    }

    public boolean isMissingDependencies() {
        return this.isMissingDependencies;
    }

    public GuiModListPanel getListPanel() {
        return this.listPanel;
    }

    public GuiModInfoPanel getInfoPanel() {
        return this.infoPanel;
    }
}

