/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui.modlist;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.modlist.GuiModListPanel;
import com.mumfrey.liteloader.client.gui.modlist.ModListContainer;
import com.mumfrey.liteloader.client.gui.modlist.ModListEntry;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class ModList {
    private final ModListContainer container;
    private final ConfigManager configManager;
    private final List<ModListEntry> mods = new ArrayList<ModListEntry>();
    private ModListEntry selectedMod = null;
    private boolean hasConfig = false;

    public ModList(ModListContainer container, ave minecraft, LiteLoaderMods mods, LoaderEnvironment environment, ConfigManager configManager, int brandColour, List<ModInfoDecorator> decorators) {
        this.container = container;
        this.configManager = configManager;
        this.populate(minecraft, mods, environment, brandColour, decorators);
    }

    protected void populate(ave minecraft, LiteLoaderMods mods, LoaderEnvironment environment, int brandColour, List<ModInfoDecorator> decorators) {
        ModListEntry modListEntry;
        TreeMap<String, ModListEntry> sortedMods = new TreeMap<String, ModListEntry>();
        for (ModInfo<LoadableMod<?>> modInfo : mods.getLoadedMods()) {
            modListEntry = new ModListEntry(this, mods, environment, minecraft.k, brandColour, decorators, modInfo);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        for (ModInfo<LoadableMod<?>> modInfo : mods.getDisabledMods()) {
            modListEntry = new ModListEntry(this, mods, environment, minecraft.k, brandColour, decorators, modInfo);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        if (sortedMods.size() == 0) {
            for (ModInfo<LoadableMod<?>> modInfo : mods.getBadContainers()) {
                modListEntry = new ModListEntry(this, mods, environment, minecraft.k, brandColour, decorators, modInfo);
                sortedMods.put(modListEntry.getKey(), modListEntry);
            }
        }
        for (ModInfo<LoadableMod<?>> modInfo : mods.getInjectedTweaks()) {
            modListEntry = new ModListEntry(this, mods, environment, minecraft.k, brandColour, decorators, modInfo);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        this.mods.addAll(sortedMods.values());
        if (this.mods.size() > 0) {
            this.selectedMod = this.mods.get(0);
        }
    }

    public GuiLiteLoaderPanel getParentScreen() {
        return this.container.getParentScreen();
    }

    public LiteMod getSelectedModInstance() {
        return this.selectedMod != null ? this.selectedMod.getModInstance() : null;
    }

    public Class<? extends LiteMod> getSelectedModClass() {
        return this.selectedMod != null ? this.selectedMod.getModClass() : null;
    }

    public void setSize(int width, int height) {
        this.selectMod(this.selectedMod);
    }

    public void onTick() {
        for (ModListEntry mod : this.mods) {
            mod.onTick();
        }
    }

    public void mousePressed(int mouseX, int mouseY, int mouseButton) {
        ModListEntry lastSelectedMod = this.selectedMod;
        for (ModListEntry mod : this.mods) {
            mod.mousePressed(mouseX, mouseY, mouseButton);
        }
        if (this.selectedMod != null && this.selectedMod == lastSelectedMod) {
            this.selectedMod.getInfoPanel().mousePressed();
        }
    }

    public boolean keyPressed(char keyChar, int keyCode) {
        if (keyCode == 200) {
            int selectedIndex = this.mods.indexOf(this.selectedMod) - 1;
            if (selectedIndex > -1) {
                this.selectMod(this.mods.get(selectedIndex));
            }
            this.scrollSelectedModIntoView();
            return true;
        }
        if (keyCode == 208) {
            int selectedIndex = this.mods.indexOf(this.selectedMod);
            if (selectedIndex > -1 && selectedIndex < this.mods.size() - 1) {
                this.selectMod(this.mods.get(selectedIndex + 1));
            }
            this.scrollSelectedModIntoView();
            return true;
        }
        if (keyCode == 57 || keyCode == 28 || keyCode == 156 || keyCode == 205) {
            this.toggleSelectedMod();
            return true;
        }
        return false;
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (this.selectedMod != null) {
            this.selectedMod.getInfoPanel().mouseReleased();
        }
    }

    public boolean mouseWheelScrolled(int mouseWheelDelta) {
        return this.selectedMod != null && this.selectedMod.getInfoPanel().mouseWheelScrolled(mouseWheelDelta);
    }

    public int drawModList(int mouseX, int mouseY, float partialTicks, int left, int top, int width, int height) {
        this.drawModListPass(mouseX, mouseY, partialTicks, left, top, width, 0);
        return this.drawModListPass(mouseX, mouseY, partialTicks, left, top, width, 1);
    }

    protected int drawModListPass(int mouseX, int mouseY, float partialTicks, int left, int top, int width, int pass) {
        int yPos = top;
        for (ModListEntry mod : this.mods) {
            GuiModListPanel panel = mod.getListPanel();
            if (!panel.isVisible()) continue;
            if (yPos > 0) {
                yPos += panel.getSpacing();
            }
            panel.draw(mouseX, mouseY, partialTicks, left, yPos, width, mod == this.selectedMod, pass);
            yPos += panel.getHeight();
        }
        return yPos;
    }

    public void drawModPanel(int mouseX, int mouseY, float partialTicks, int left, int top, int width, int height) {
        if (this.selectedMod != null) {
            this.selectedMod.getInfoPanel().draw(mouseX, mouseY, partialTicks, left, top, width, height);
        }
    }

    void selectMod(ModListEntry mod) {
        if (this.selectedMod != null) {
            this.selectedMod.getInfoPanel().mouseReleased();
        }
        this.selectedMod = mod;
        this.hasConfig = false;
        this.container.setEnableButtonVisible(false);
        this.container.setConfigButtonVisible(false);
        if (this.selectedMod != null && this.selectedMod.canBeToggled()) {
            this.container.setEnableButtonVisible(true);
            this.container.setEnableButtonText(this.selectedMod.willBeEnabled() ? bnq.a((String)"gui.disablemod", (Object[])new Object[0]) : bnq.a((String)"gui.enablemod", (Object[])new Object[0]));
            this.hasConfig = this.configManager.hasPanel(this.selectedMod.getModClass());
            this.container.setConfigButtonVisible(this.hasConfig);
        }
    }

    public void toggleSelectedMod() {
        if (this.selectedMod != null) {
            this.selectedMod.toggleEnabled();
            this.selectMod(this.selectedMod);
        }
    }

    private void scrollSelectedModIntoView() {
        if (this.selectedMod == null) {
            return;
        }
        int yPos = 0;
        for (ModListEntry mod : this.mods) {
            if (mod == this.selectedMod) break;
            yPos += mod.getListPanel().getTotalHeight();
        }
        int modHeight = this.selectedMod.getListPanel().getTotalHeight();
        this.container.scrollTo(yPos, yPos + modHeight);
    }

    public void showConfig(ModListEntry modListEntry) {
        this.container.showConfig();
    }
}

