/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.mumfrey.liteloader.api.CoreProvider;
import com.mumfrey.liteloader.api.CustomisationProvider;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Observer;
import com.mumfrey.liteloader.client.LiteLoaderCoreProviderClient;
import com.mumfrey.liteloader.client.ResourceObserver;
import com.mumfrey.liteloader.client.Translator;
import com.mumfrey.liteloader.client.api.LiteLoaderBrandingProvider;
import com.mumfrey.liteloader.client.api.LiteLoaderModInfoDecorator;
import com.mumfrey.liteloader.client.api.ObjectFactoryClient;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.interfaces.ObjectFactory;
import com.mumfrey.liteloader.messaging.MessageBus;
import com.mumfrey.liteloader.transformers.event.json.ModEvents;
import java.util.List;

public class LiteLoaderCoreAPIClient
extends LiteLoaderCoreAPI {
    private static final String PKG_LITELOADER_CLIENT = "com.mumfrey.liteloader.client";
    private static final String[] requiredTransformers = new String[]{"com.mumfrey.liteloader.transformers.event.EventProxyTransformer", "com.mumfrey.liteloader.launch.LiteLoaderTransformer", "com.mumfrey.liteloader.client.transformers.CrashReportTransformer"};
    private static final String[] requiredDownstreamTransformers = new String[]{"com.mumfrey.liteloader.common.transformers.LiteLoaderPacketTransformer", "com.mumfrey.liteloader.client.transformers.MinecraftTransformer", "com.mumfrey.liteloader.transformers.event.json.ModEventInjectionTransformer"};
    private ObjectFactory<ave, bpo> objectFactory;

    @Override
    public String[] getMixinConfigs() {
        Object[] commonConfigs = super.getMixinConfigs();
        return (String[])ObjectArrays.concat((Object[])commonConfigs, (Object[])new String[]{"mixins.liteloader.client.json"}, String.class);
    }

    @Override
    public String[] getRequiredTransformers() {
        return requiredTransformers;
    }

    @Override
    public String[] getRequiredDownstreamTransformers() {
        return requiredDownstreamTransformers;
    }

    @Override
    public List<CustomisationProvider> getCustomisationProviders() {
        return ImmutableList.of((Object)new LiteLoaderBrandingProvider(), (Object)new LiteLoaderModInfoDecorator(), (Object)new Translator());
    }

    @Override
    public List<CoreProvider> getCoreProviders() {
        return ImmutableList.of((Object)new LiteLoaderCoreProviderClient(this.properties), (Object)LiteLoader.getInput());
    }

    @Override
    public List<InterfaceProvider> getInterfaceProviders() {
        ObjectFactory<?, ?> objectFactory = this.getObjectFactory();
        return ImmutableList.of(objectFactory.getEventBroker(), (Object)objectFactory.getPacketEventBroker(), (Object)objectFactory.getClientPluginChannels(), (Object)objectFactory.getServerPluginChannels(), (Object)MessageBus.getInstance());
    }

    @Override
    public List<Observer> getPreInitObservers() {
        return ImmutableList.of((Object)new ModEvents());
    }

    @Override
    public List<Observer> getObservers() {
        ObjectFactory<?, ?> objectFactory = this.getObjectFactory();
        return ImmutableList.of((Object)new ResourceObserver(), objectFactory.getPanelManager(), objectFactory.getEventBroker());
    }

    @Override
    public ObjectFactory<?, ?> getObjectFactory() {
        if (this.objectFactory == null) {
            this.objectFactory = new ObjectFactoryClient(this.environment, this.properties);
        }
        return this.objectFactory;
    }
}

